/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.utils.StringValueTable;

public final class Opcode {
    private static StringValueTable opcodes = new StringValueTable();
    public static final byte QUERY = 0;
    public static final byte NOTIFY = 4;
    public static final byte UPDATE = 5;

    public static String string(int n) {
        String string = opcodes.getString(n);
        return string != null ? string : new Integer(n).toString();
    }

    public static byte value(String string) {
        byte by = (byte)opcodes.getValue(string.toUpperCase());
        if (by >= 0) {
            return by;
        }
        try {
            return Byte.parseByte(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private Opcode() {
    }

    static {
        opcodes.put2(0, "QUERY");
        opcodes.put2(4, "NOTIFY");
        opcodes.put2(5, "UPDATE");
    }
}

