/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.UNKRecord;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public abstract class Record {
    protected Name name;
    protected short type;
    protected short dclass;
    protected int ttl;
    protected int wireLength = -1;
    private static /* synthetic */ Class class$Lorg$xbill$DNS$Record;
    private static /* synthetic */ Class class$Lorg$xbill$DNS$Name;
    private static /* synthetic */ Class class$Lorg$xbill$DNS$utils$DataByteInputStream;
    private static /* synthetic */ Class class$Lorg$xbill$DNS$Compression;
    private static /* synthetic */ Class class$Lorg$xbill$DNS$utils$MyStringTokenizer;

    private static Class toClass(short s) throws ClassNotFoundException {
        String string = (class$Lorg$xbill$DNS$Record != null ? class$Lorg$xbill$DNS$Record : (class$Lorg$xbill$DNS$Record = Record.class$("org.xbill.DNS.Record"))).toString();
        return Class.forName(string.substring(6, string.length() - 6) + Type.string(s) + "Record");
    }

    private static Record newRecord(Name name, short s, short s2, int n, int n2, DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        try {
            Class clazz = Record.toClass(s);
            Constructor constructor = clazz.getDeclaredConstructor(class$Lorg$xbill$DNS$Name != null ? class$Lorg$xbill$DNS$Name : (class$Lorg$xbill$DNS$Name = Record.class$("org.xbill.DNS.Name")), Short.TYPE, Integer.TYPE, Integer.TYPE, class$Lorg$xbill$DNS$utils$DataByteInputStream != null ? class$Lorg$xbill$DNS$utils$DataByteInputStream : (class$Lorg$xbill$DNS$utils$DataByteInputStream = Record.class$("org.xbill.DNS.utils.DataByteInputStream")), class$Lorg$xbill$DNS$Compression != null ? class$Lorg$xbill$DNS$Compression : (class$Lorg$xbill$DNS$Compression = Record.class$("org.xbill.DNS.Compression")));
            Record record = (Record)constructor.newInstance(name, new Short(s2), new Integer(n), new Integer(n2), dataByteInputStream, compression);
            return record;
        }
        catch (ClassNotFoundException classNotFoundException) {
            UNKRecord uNKRecord = new UNKRecord(name, s, s2, n, n2, dataByteInputStream, compression);
            uNKRecord.wireLength = n2;
            return uNKRecord;
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("new record: " + invocationTargetException);
            System.out.println(invocationTargetException.getTargetException());
            return null;
        }
        catch (Exception exception) {
            System.out.println("new record: " + exception);
            return null;
        }
    }

    public static Record newRecord(Name name, short s, short s2, int n, int n2, byte[] byArray) {
        DataByteInputStream dataByteInputStream = byArray != null ? new DataByteInputStream(byArray) : null;
        try {
            return Record.newRecord(name, s, s2, n, n2, dataByteInputStream, null);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Record newRecord(Name name, short s, short s2, int n) {
        return Record.newRecord(name, s, s2, n, 0, null);
    }

    public static Record newRecord(Name name, short s, short s2) {
        return Record.newRecord(name, s, s2, 0, 0, null);
    }

    static Record fromWire(DataByteInputStream dataByteInputStream, int n, Compression compression) throws IOException {
        int n2 = dataByteInputStream.getPos();
        Name name = new Name(dataByteInputStream, compression);
        short s = dataByteInputStream.readShort();
        short s2 = dataByteInputStream.readShort();
        if (n == 0) {
            return Record.newRecord(name, s, s2);
        }
        int n3 = dataByteInputStream.readInt();
        short s3 = dataByteInputStream.readShort();
        int n4 = dataByteInputStream.getPos();
        Record record = Record.newRecord(name, s, s2, n3, s3, dataByteInputStream, compression);
        if (dataByteInputStream.getPos() - n4 != s3) {
            throw new IOException("Invalid record length");
        }
        record.wireLength = dataByteInputStream.getPos() - n2;
        return record;
    }

    public static Record fromWire(byte[] byArray, int n) throws IOException {
        DataByteInputStream dataByteInputStream = new DataByteInputStream(byArray);
        return Record.fromWire(dataByteInputStream, n, null);
    }

    void toWire(DataByteOutputStream dataByteOutputStream, int n, Compression compression) throws IOException {
        int n2 = dataByteOutputStream.getPos();
        this.name.toWire(dataByteOutputStream, compression);
        dataByteOutputStream.writeShort(this.type);
        dataByteOutputStream.writeShort(this.dclass);
        if (n == 0) {
            return;
        }
        dataByteOutputStream.writeInt(this.ttl);
        int n3 = dataByteOutputStream.getPos();
        dataByteOutputStream.writeShort(0);
        this.rrToWire(dataByteOutputStream, compression);
        dataByteOutputStream.writeShortAt(dataByteOutputStream.getPos() - n3 - 2, n3);
        this.wireLength = dataByteOutputStream.getPos() - n2;
    }

    public byte[] toWire(int n) throws IOException {
        DataByteOutputStream dataByteOutputStream = new DataByteOutputStream();
        this.toWire(dataByteOutputStream, n, null);
        return dataByteOutputStream.toByteArray();
    }

    void toWireCanonical(DataByteOutputStream dataByteOutputStream) throws IOException {
        this.name.toWireCanonical(dataByteOutputStream);
        dataByteOutputStream.writeShort(this.type);
        dataByteOutputStream.writeShort(this.dclass);
        dataByteOutputStream.writeInt(this.ttl);
        int n = dataByteOutputStream.getPos();
        dataByteOutputStream.writeShort(0);
        this.rrToWireCanonical(dataByteOutputStream);
        dataByteOutputStream.writeShortAt(dataByteOutputStream.getPos() - n - 2, n);
    }

    public byte[] toWireCanonical() throws IOException {
        DataByteOutputStream dataByteOutputStream = new DataByteOutputStream();
        this.toWireCanonical(dataByteOutputStream);
        return dataByteOutputStream.toByteArray();
    }

    StringBuffer toStringNoData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append("\t");
        stringBuffer.append(this.ttl);
        stringBuffer.append("\t");
        stringBuffer.append(DClass.string(this.dclass));
        stringBuffer.append("\t");
        stringBuffer.append(Type.string(this.type));
        stringBuffer.append("\t");
        return stringBuffer;
    }

    public String toString() {
        StringBuffer stringBuffer = this.toStringNoData();
        stringBuffer.append("<unknown format>");
        return stringBuffer.toString();
    }

    public static Record fromString(Name name, short s, short s2, int n, MyStringTokenizer myStringTokenizer, Name name2) throws IOException {
        try {
            Class clazz = Record.toClass(s);
            Constructor constructor = clazz.getDeclaredConstructor(class$Lorg$xbill$DNS$Name != null ? class$Lorg$xbill$DNS$Name : (class$Lorg$xbill$DNS$Name = Record.class$("org.xbill.DNS.Name")), Short.TYPE, Integer.TYPE, class$Lorg$xbill$DNS$utils$MyStringTokenizer != null ? class$Lorg$xbill$DNS$utils$MyStringTokenizer : (class$Lorg$xbill$DNS$utils$MyStringTokenizer = Record.class$("org.xbill.DNS.utils.MyStringTokenizer")), class$Lorg$xbill$DNS$Name != null ? class$Lorg$xbill$DNS$Name : (class$Lorg$xbill$DNS$Name = Record.class$("org.xbill.DNS.Name")));
            Record record = (Record)constructor.newInstance(name, new Short(s2), new Integer(n), myStringTokenizer, name2);
            return record;
        }
        catch (ClassNotFoundException classNotFoundException) {
            UNKRecord uNKRecord = new UNKRecord(name, s, s2, n, myStringTokenizer, name2);
            return uNKRecord;
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("from text: " + invocationTargetException);
            System.out.println(invocationTargetException.getTargetException());
            return null;
        }
        catch (Exception exception) {
            System.out.println("from text: " + exception);
            return null;
        }
    }

    public Name getName() {
        return this.name;
    }

    public short getType() {
        return this.type;
    }

    public short getRRsetType() {
        if (this.type == 24) {
            SIGRecord sIGRecord = (SIGRecord)this;
            return sIGRecord.getTypeCovered();
        }
        return this.type;
    }

    public short getDClass() {
        return this.dclass;
    }

    public int getTTL() {
        return this.ttl;
    }

    public short getWireLength() {
        return (short)this.wireLength;
    }

    abstract void rrToWire(DataByteOutputStream var1, Compression var2) throws IOException;

    void rrToWireCanonical(DataByteOutputStream dataByteOutputStream) throws IOException {
        this.rrToWire(dataByteOutputStream, null);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Record)) {
            return false;
        }
        Record record = (Record)object;
        try {
            byte[] byArray = this.toWire(1);
            byte[] byArray2 = record.toWire(1);
            if (byArray.length != byArray2.length) {
                return false;
            }
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] != byArray2[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            byte[] byArray = this.toWire(1);
            return byArray.hashCode();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Record() {
    }

    Record(Name name, short s, short s2, int n) {
        this.name = name;
        this.type = s;
        this.dclass = s2;
        this.ttl = n;
    }
}

