/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TTL;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base64;

public class SIGRecord
extends Record {
    private short covered;
    private byte alg;
    private byte labels;
    private int origttl;
    private Date expire;
    private Date timeSigned;
    private short footprint;
    private Name signer;
    private byte[] signature;

    public String toString() {
        StringBuffer stringBuffer = this.toStringNoData();
        if (this.signature != null) {
            stringBuffer.append(Type.string(this.covered));
            stringBuffer.append(" ");
            stringBuffer.append(this.alg);
            stringBuffer.append(" ");
            stringBuffer.append(this.origttl);
            stringBuffer.append(" (\n\t");
            stringBuffer.append(this.formatDate(this.expire));
            stringBuffer.append(" ");
            stringBuffer.append(this.formatDate(this.timeSigned));
            stringBuffer.append(" ");
            stringBuffer.append(this.footprint & 0xFFFF);
            stringBuffer.append(" ");
            stringBuffer.append(this.signer);
            stringBuffer.append("\n");
            stringBuffer.append(base64.formatString(this.signature, 64, "\t", true));
        }
        return stringBuffer.toString();
    }

    public short getTypeCovered() {
        return this.covered;
    }

    public byte getAlgorithm() {
        return this.alg;
    }

    public byte getLabels() {
        return this.labels;
    }

    public int getOrigTTL() {
        return this.origttl;
    }

    public Date getExpire() {
        return this.expire;
    }

    public Date getTimeSigned() {
        return this.timeSigned;
    }

    public short getFootprint() {
        return this.footprint;
    }

    public Name getSigner() {
        return this.signer;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    void rrToWire(DataByteOutputStream dataByteOutputStream, Compression compression) throws IOException {
        if (this.signature == null) {
            return;
        }
        dataByteOutputStream.writeShort(this.covered);
        dataByteOutputStream.writeByte(this.alg);
        dataByteOutputStream.writeByte(this.labels);
        dataByteOutputStream.writeInt(this.origttl);
        dataByteOutputStream.writeInt((int)(this.expire.getTime() / 1000L));
        dataByteOutputStream.writeInt((int)(this.timeSigned.getTime() / 1000L));
        dataByteOutputStream.writeShort(this.footprint);
        this.signer.toWire(dataByteOutputStream, null);
        dataByteOutputStream.write(this.signature);
    }

    void rrToWireCanonical(DataByteOutputStream dataByteOutputStream) throws IOException {
        if (this.signature == null) {
            return;
        }
        dataByteOutputStream.writeShort(this.covered);
        dataByteOutputStream.writeByte(this.alg);
        dataByteOutputStream.writeByte(this.labels);
        dataByteOutputStream.writeInt(this.origttl);
        dataByteOutputStream.writeInt((int)(this.expire.getTime() / 1000L));
        dataByteOutputStream.writeInt((int)(this.timeSigned.getTime() / 1000L));
        dataByteOutputStream.writeShort(this.footprint);
        this.signer.toWireCanonical(dataByteOutputStream);
        dataByteOutputStream.write(this.signature);
    }

    private String formatDate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat();
        ((NumberFormat)decimalFormat).setMinimumIntegerDigits(4);
        ((NumberFormat)decimalFormat).setGroupingUsed(false);
        DecimalFormat decimalFormat2 = new DecimalFormat();
        ((NumberFormat)decimalFormat2).setMinimumIntegerDigits(2);
        gregorianCalendar.setTime(date);
        stringBuffer.append(decimalFormat.format(gregorianCalendar.get(1)));
        stringBuffer.append(decimalFormat2.format(gregorianCalendar.get(2) + 1));
        stringBuffer.append(decimalFormat2.format(gregorianCalendar.get(5)));
        stringBuffer.append(decimalFormat2.format(gregorianCalendar.get(11)));
        stringBuffer.append(decimalFormat2.format(gregorianCalendar.get(12)));
        stringBuffer.append(decimalFormat2.format(gregorianCalendar.get(13)));
        return stringBuffer.toString();
    }

    private Date parseDate(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        int n = Integer.parseInt(string.substring(0, 4));
        int n2 = Integer.parseInt(string.substring(4, 6));
        int n3 = Integer.parseInt(string.substring(6, 8));
        int n4 = Integer.parseInt(string.substring(8, 10));
        int n5 = Integer.parseInt(string.substring(10, 12));
        int n6 = Integer.parseInt(string.substring(12, 14));
        gregorianCalendar.set(n, n2, n3, n4, n5, n6);
        return gregorianCalendar.getTime();
    }

    private SIGRecord() {
    }

    public SIGRecord(Name name, short s, int n, int n2, int n3, int n4, Date date, Date date2, int n5, Name name2, byte[] byArray) {
        super(name, (short)24, s, n);
        this.covered = (short)n2;
        this.alg = (byte)n3;
        this.labels = this.name.labels();
        this.origttl = n4;
        this.expire = date;
        this.timeSigned = date2;
        this.footprint = (short)n5;
        this.signer = name2;
        this.signature = byArray;
    }

    SIGRecord(Name name, short s, int n, int n2, DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        super(name, (short)24, s, n);
        if (dataByteInputStream == null) {
            return;
        }
        int n3 = dataByteInputStream.getPos();
        this.covered = dataByteInputStream.readShort();
        this.alg = dataByteInputStream.readByte();
        this.labels = dataByteInputStream.readByte();
        this.origttl = dataByteInputStream.readInt();
        this.expire = new Date(1000L * (long)dataByteInputStream.readInt());
        this.timeSigned = new Date(1000L * (long)dataByteInputStream.readInt());
        this.footprint = dataByteInputStream.readShort();
        this.signer = new Name(dataByteInputStream, compression);
        this.signature = new byte[n2 - (dataByteInputStream.getPos() - n3)];
        dataByteInputStream.read(this.signature);
    }

    SIGRecord(Name name, short s, int n, MyStringTokenizer myStringTokenizer, Name name2) throws IOException {
        super(name, (short)24, s, n);
        this.covered = Type.value(myStringTokenizer.nextToken());
        this.alg = Byte.parseByte(myStringTokenizer.nextToken());
        this.labels = this.name.labels();
        this.origttl = TTL.parseTTL(myStringTokenizer.nextToken());
        this.expire = this.parseDate(myStringTokenizer.nextToken());
        this.timeSigned = this.parseDate(myStringTokenizer.nextToken());
        this.footprint = (short)Integer.parseInt(myStringTokenizer.nextToken());
        this.signer = new Name(myStringTokenizer.nextToken(), name2);
        if (myStringTokenizer.hasMoreTokens()) {
            this.signature = base64.fromString(myStringTokenizer.remainingTokens());
        }
    }
}

