/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.xbill.DNS.EDNS;
import org.xbill.DNS.FindServer;
import org.xbill.DNS.Message;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolveThread;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.utils.base64;
import org.xbill.Task.WorkerThread;

public class SimpleResolver
implements Resolver {
    public static final int PORT = 53;
    private static String defaultResolver = "localhost";
    private static int uniqueID = 0;
    private InetAddress addr;
    private int port = 53;
    private boolean useTCP;
    private boolean ignoreTruncation;
    private int EDNSlevel = -1;
    private TSIG tsig;
    private int timeoutValue = 60000;

    public static void setDefaultResolver(String string) {
        defaultResolver = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setTCP(boolean bl) {
        this.useTCP = bl;
    }

    public void setIgnoreTruncation(boolean bl) {
        this.ignoreTruncation = bl;
    }

    public void setEDNS(int n) {
        this.EDNSlevel = n;
    }

    public void setTSIGKey(String string, String string2) {
        byte[] byArray = base64.fromString(string2);
        if (byArray == null) {
            System.out.println("Invalid TSIG key string");
            return;
        }
        this.tsig = new TSIG(string, byArray);
    }

    public void setTSIGKey(String string) {
        String string2;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("getLocalHost failed");
            return;
        }
        this.setTSIGKey(string2, string);
    }

    public void setTimeout(int n) {
        this.timeoutValue = n * 1000;
    }

    private Message sendTCP(Message message, byte[] byArray) throws IOException {
        Message message2;
        byte[] byArray2;
        Socket socket = new Socket(this.addr, this.port);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
            socket.setSoTimeout(this.timeoutValue);
            try {
                DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                int n = dataInputStream.readUnsignedShort();
                byArray2 = new byte[n];
                dataInputStream.readFully(byArray2);
            }
            catch (IOException iOException) {
                System.out.println(";; No response");
                throw iOException;
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            socket.close();
            throw throwable;
        }
        socket.close();
        try {
            message2 = new Message(byArray2);
        }
        catch (IOException iOException) {
            throw new WireParseException("Error parsing message");
        }
        if (this.tsig != null) {
            boolean bl = this.tsig.verify(message2, byArray2, message.getTSIG());
            System.out.println(";; TSIG verify: " + bl);
        }
        return message2;
    }

    public Message send(Message message) throws IOException {
        Message message2;
        DatagramPacket datagramPacket;
        int n = 512;
        message = (Message)message.clone();
        if (this.EDNSlevel >= 0) {
            n = 1280;
            message.addRecord(EDNS.newOPT(n), 3);
        }
        if (this.tsig != null) {
            this.tsig.apply(message, null);
        }
        byte[] byArray = message.toWire();
        if (this.useTCP || byArray.length > n) {
            return this.sendTCP(message, byArray);
        }
        DatagramSocket datagramSocket = new DatagramSocket();
        try {
            datagramSocket.send(new DatagramPacket(byArray, byArray.length, this.addr, this.port));
            datagramPacket = new DatagramPacket(new byte[n], n);
            datagramSocket.setSoTimeout(this.timeoutValue);
            try {
                datagramSocket.receive(datagramPacket);
            }
            catch (IOException iOException) {
                System.out.println(";; No response");
                throw iOException;
            }
            Object var9_9 = null;
            datagramSocket.close();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            datagramSocket.close();
            throw throwable;
        }
        byte[] byArray2 = new byte[datagramPacket.getLength()];
        System.arraycopy(datagramPacket.getData(), 0, byArray2, 0, byArray2.length);
        try {
            message2 = new Message(byArray2);
        }
        catch (IOException iOException) {
            throw new WireParseException("Error parsing message");
        }
        if (this.tsig != null) {
            boolean bl = this.tsig.verify(message2, byArray2, message.getTSIG());
            System.out.println(";; TSIG verify: " + bl);
        }
        datagramSocket.close();
        if (message2.getHeader().getFlag(6) && !this.ignoreTruncation) {
            return this.sendTCP(message, byArray);
        }
        return message2;
    }

    public Object sendAsync(Message message, ResolverListener resolverListener) {
        Integer n;
        Object object = this;
        synchronized (object) {
            n = new Integer(uniqueID++);
        }
        object = this.getClass() + ": " + message.getQuestion().getName();
        WorkerThread.assignThread(new ResolveThread(this, message, n, resolverListener), (String)object);
        return n;
    }

    public Message sendAXFR(Message message) throws IOException {
        Message message2;
        int n = 0;
        boolean bl = true;
        Socket socket = new Socket(this.addr, this.port);
        try {
            message = (Message)message.clone();
            if (this.tsig != null) {
                this.tsig.apply(message, null);
            }
            byte[] byArray = message.toWire();
            OutputStream outputStream = socket.getOutputStream();
            new DataOutputStream(outputStream).writeShort(byArray.length);
            outputStream.write(byArray);
            socket.setSoTimeout(this.timeoutValue);
            message2 = new Message();
            message2.getHeader().setID(message.getHeader().getID());
            if (this.tsig != null) {
                this.tsig.verifyAXFRStart();
            }
            while (n < 2) {
                Message message3;
                byte[] byArray2;
                try {
                    InputStream inputStream = socket.getInputStream();
                    DataInputStream dataInputStream = new DataInputStream(inputStream);
                    int n2 = dataInputStream.readUnsignedShort();
                    byArray2 = new byte[n2];
                    dataInputStream.readFully(byArray2);
                }
                catch (IOException iOException) {
                    System.out.println(";; No response");
                    throw iOException;
                }
                try {
                    message3 = new Message(byArray2);
                }
                catch (IOException iOException) {
                    throw new WireParseException("Error parsing message");
                }
                if (message3.getHeader().getCount(0) > 1 || message3.getHeader().getCount(1) <= 0 || message3.getHeader().getCount(2) != 0) {
                    System.out.println("Invalid AXFR packet: ");
                    System.out.println(message3);
                    throw new WireParseException("Invalid AXFR message");
                }
                boolean bl2 = true;
                while (bl2 < 4 != 0) {
                    Enumeration enumeration = message3.getSection(bl2 ? 1 : 0);
                    while (enumeration.hasMoreElements()) {
                        Record record = (Record)enumeration.nextElement();
                        message2.addRecord(record, bl2 ? 1 : 0);
                        if (!(record instanceof SOARecord)) continue;
                        ++n;
                    }
                    bl2 += 1;
                }
                if (this.tsig != null) {
                    bl2 = n > 1 || bl;
                    boolean bl3 = this.tsig.verifyAXFR(message3, byArray2, message.getTSIG(), bl2, bl);
                    System.out.println("TSIG verify: " + bl3);
                }
                bl = false;
            }
        }
        finally {
            Object var12_19 = null;
            socket.close();
        }
        return message2;
    }

    public SimpleResolver(String string) throws UnknownHostException {
        if (string == null && (string = FindServer.server()) == null) {
            string = defaultResolver;
        }
        this.addr = InetAddress.getByName(string);
    }

    public SimpleResolver() throws UnknownHostException {
        this(null);
    }
}

