/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.hmacSigner;

public class TSIG {
    public static final String HMAC = "HMAC-MD5.SIG-ALG.REG.INT";
    private Name name;
    private byte[] key;
    private hmacSigner axfrSigner = null;

    public void apply(Message message, TSIGRecord tSIGRecord) throws IOException {
        Object object;
        Date date = new Date();
        short s = 300;
        hmacSigner hmacSigner2 = new hmacSigner(this.key);
        Name name = new Name(HMAC);
        try {
            if (tSIGRecord != null) {
                object = new DataByteOutputStream();
                ((DataByteOutputStream)object).writeShort((short)tSIGRecord.getSignature().length);
                hmacSigner2.addData(((ByteArrayOutputStream)object).toByteArray());
                hmacSigner2.addData(tSIGRecord.getSignature());
            }
            hmacSigner2.addData(message.toWire());
            object = new DataByteOutputStream();
            this.name.toWireCanonical((DataByteOutputStream)object);
            ((DataByteOutputStream)object).writeShort(255);
            ((DataByteOutputStream)object).writeInt(0);
            name.toWireCanonical((DataByteOutputStream)object);
            long l = date.getTime() / 1000L;
            short s2 = (short)(l >> 32);
            int n = (int)l;
            ((DataByteOutputStream)object).writeShort(s2);
            ((DataByteOutputStream)object).writeInt(n);
            ((DataByteOutputStream)object).writeShort(s);
            ((DataByteOutputStream)object).writeShort(0);
            ((DataByteOutputStream)object).writeShort(0);
            hmacSigner2.addData(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (IOException iOException) {
            return;
        }
        object = new TSIGRecord(this.name, 255, 0, name, date, s, hmacSigner2.sign(), message.getHeader().getID(), 0, null);
        message.addRecord((Record)object, 3);
    }

    public boolean verify(Message message, byte[] byArray, TSIGRecord tSIGRecord) {
        Object object;
        TSIGRecord tSIGRecord2 = message.getTSIG();
        hmacSigner hmacSigner2 = new hmacSigner(this.key);
        if (tSIGRecord2 == null) {
            return false;
        }
        try {
            if (tSIGRecord != null && tSIGRecord2.getError() == 0) {
                object = new DataByteOutputStream();
                ((DataByteOutputStream)object).writeShort((short)tSIGRecord.getSignature().length);
                hmacSigner2.addData(((ByteArrayOutputStream)object).toByteArray());
                hmacSigner2.addData(tSIGRecord.getSignature());
            }
            message.getHeader().decCount(3);
            object = message.getHeader().toWire();
            message.getHeader().incCount(3);
            hmacSigner2.addData((byte[])object);
            int n = byArray.length - ((Object)object).length;
            hmacSigner2.addData(byArray, ((Object)object).length, n -= tSIGRecord2.wireLength);
            DataByteOutputStream dataByteOutputStream = new DataByteOutputStream();
            tSIGRecord2.getName().toWireCanonical(dataByteOutputStream);
            dataByteOutputStream.writeShort(tSIGRecord2.dclass);
            dataByteOutputStream.writeInt(tSIGRecord2.ttl);
            tSIGRecord2.getAlg().toWireCanonical(dataByteOutputStream);
            long l = tSIGRecord2.getTimeSigned().getTime() / 1000L;
            short s = (short)(l >> 32);
            int n2 = (int)l;
            dataByteOutputStream.writeShort(s);
            dataByteOutputStream.writeInt(n2);
            dataByteOutputStream.writeShort(tSIGRecord2.getFudge());
            dataByteOutputStream.writeShort(tSIGRecord2.getError());
            if (tSIGRecord2.getOther() != null) {
                dataByteOutputStream.writeShort(tSIGRecord2.getOther().length);
                dataByteOutputStream.write(tSIGRecord2.getOther());
            } else {
                dataByteOutputStream.writeShort(0);
            }
            hmacSigner2.addData(dataByteOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            return false;
        }
        if (this.axfrSigner != null) {
            object = new DataByteOutputStream();
            ((DataByteOutputStream)object).writeShort((short)tSIGRecord2.getSignature().length);
            this.axfrSigner.addData(((ByteArrayOutputStream)object).toByteArray());
            this.axfrSigner.addData(tSIGRecord2.getSignature());
        }
        return hmacSigner2.verify(tSIGRecord2.getSignature());
    }

    public void verifyAXFRStart() {
        this.axfrSigner = new hmacSigner(this.key);
    }

    public boolean verifyAXFR(Message message, byte[] byArray, TSIGRecord tSIGRecord, boolean bl, boolean bl2) {
        Object object;
        TSIGRecord tSIGRecord2 = message.getTSIG();
        hmacSigner hmacSigner2 = this.axfrSigner;
        if (bl2) {
            return this.verify(message, byArray, tSIGRecord);
        }
        try {
            if (tSIGRecord2 != null) {
                message.getHeader().decCount(3);
            }
            object = message.getHeader().toWire();
            if (tSIGRecord2 != null) {
                message.getHeader().incCount(3);
            }
            hmacSigner2.addData((byte[])object);
            int n = byArray.length - ((byte[])object).length;
            if (tSIGRecord2 != null) {
                n -= tSIGRecord2.wireLength;
            }
            hmacSigner2.addData(byArray, ((byte[])object).length, n);
            if (tSIGRecord2 == null) {
                return !bl;
            }
            DataByteOutputStream dataByteOutputStream = new DataByteOutputStream();
            long l = tSIGRecord2.getTimeSigned().getTime() / 1000L;
            short s = (short)(l >> 32);
            int n2 = (int)l;
            dataByteOutputStream.writeShort(s);
            dataByteOutputStream.writeInt(n2);
            dataByteOutputStream.writeShort(tSIGRecord2.getFudge());
            hmacSigner2.addData(dataByteOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            return false;
        }
        if (!hmacSigner2.verify(tSIGRecord2.getSignature())) {
            return false;
        }
        hmacSigner2.clear();
        object = new DataByteOutputStream();
        ((DataByteOutputStream)object).writeShort((short)tSIGRecord.getSignature().length);
        hmacSigner2.addData(((ByteArrayOutputStream)object).toByteArray());
        hmacSigner2.addData(tSIGRecord2.getSignature());
        return true;
    }

    public TSIG(String string, byte[] byArray) {
        this.name = new Name(string);
        this.key = byArray;
    }
}

