/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Date;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.base64;

public class TSIGRecord
extends Record {
    private Name alg;
    private Date timeSigned;
    private short fudge;
    private byte[] signature;
    private int originalID;
    private short error;
    private byte[] other;

    public String toString() {
        StringBuffer stringBuffer = this.toStringNoData();
        if (this.alg == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append(this.alg);
        stringBuffer.append(" (\n\t");
        stringBuffer.append(this.timeSigned.getTime() / 1000L);
        stringBuffer.append(" ");
        stringBuffer.append(Rcode.string(this.error));
        stringBuffer.append("\n");
        stringBuffer.append(base64.formatString(this.signature, 64, "\t", false));
        if (this.other != null) {
            stringBuffer.append("\n\t <");
            if (this.error == 18) {
                try {
                    DataByteInputStream dataByteInputStream = new DataByteInputStream(this.other);
                    long l = dataByteInputStream.readUnsignedShort();
                    l <<= 32;
                    stringBuffer.append("Server time: ");
                    stringBuffer.append(new Date((l += (long)dataByteInputStream.readInt() & 0xFFFFFFFFFFFFFFFFL) * 1000L));
                }
                catch (IOException iOException) {
                    stringBuffer.append("Truncated BADTIME other data");
                }
            } else {
                stringBuffer.append(base64.toString(this.other));
            }
            stringBuffer.append(">");
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    public Name getAlg() {
        return this.alg;
    }

    public Date getTimeSigned() {
        return this.timeSigned;
    }

    public short getFudge() {
        return this.fudge;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int getOriginalID() {
        return this.originalID;
    }

    public short getError() {
        return this.error;
    }

    public byte[] getOther() {
        return this.other;
    }

    void rrToWire(DataByteOutputStream dataByteOutputStream, Compression compression) throws IOException {
        if (this.alg == null) {
            return;
        }
        this.alg.toWire(dataByteOutputStream, null);
        long l = this.timeSigned.getTime() / 1000L;
        short s = (short)(l >> 32);
        int n = (int)l;
        dataByteOutputStream.writeShort(s);
        dataByteOutputStream.writeInt(n);
        dataByteOutputStream.writeShort(this.fudge);
        dataByteOutputStream.writeShort((short)this.signature.length);
        dataByteOutputStream.write(this.signature);
        dataByteOutputStream.writeShort(this.originalID);
        dataByteOutputStream.writeShort(this.error);
        if (this.other != null) {
            dataByteOutputStream.writeShort((short)this.other.length);
            dataByteOutputStream.write(this.other);
        } else {
            dataByteOutputStream.writeShort(0);
        }
    }

    void rrToWireCanonical(DataByteOutputStream dataByteOutputStream) throws IOException {
        throw new IOException("A TSIG should never be converted to canonical");
    }

    public TSIGRecord(Name name, short s, int n, Name name2, Date date, short s2, byte[] byArray, int n2, short s3, byte[] byArray2) throws IOException {
        super(name, (short)250, s, n);
        this.alg = name2;
        this.timeSigned = date;
        this.fudge = s2;
        this.signature = byArray;
        this.originalID = n2;
        this.error = s3;
        this.other = byArray2;
    }

    TSIGRecord(Name name, short s, int n, int n2, DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        super(name, (short)250, s, n);
        if (dataByteInputStream == null) {
            return;
        }
        this.alg = new Name(dataByteInputStream, compression);
        short s2 = dataByteInputStream.readShort();
        int n3 = dataByteInputStream.readInt();
        long l = ((long)s2 & 0xFFFFL) << 32;
        this.timeSigned = new Date((l += (long)n3 & 0xFFFFFFFFFFFFFFFFL) * 1000L);
        this.fudge = dataByteInputStream.readShort();
        int n4 = dataByteInputStream.readUnsignedShort();
        this.signature = new byte[n4];
        dataByteInputStream.read(this.signature);
        this.originalID = dataByteInputStream.readUnsignedShort();
        this.error = dataByteInputStream.readShort();
        int n5 = dataByteInputStream.readUnsignedShort();
        if (n5 > 0) {
            this.other = new byte[n5];
            dataByteInputStream.read(this.other);
        } else {
            this.other = null;
        }
    }
}

