/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class TXTRecord
extends Record {
    private Vector strings;

    public String toString() {
        StringBuffer stringBuffer = this.toStringNoData();
        if (this.strings != null) {
            Enumeration enumeration = this.strings.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("\"");
                stringBuffer.append(string);
                stringBuffer.append("\" ");
            }
        }
        return stringBuffer.toString();
    }

    public Vector getStrings() {
        return this.strings;
    }

    void rrToWire(DataByteOutputStream dataByteOutputStream, Compression compression) throws IOException {
        if (this.strings == null) {
            return;
        }
        Enumeration enumeration = this.strings.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            dataByteOutputStream.writeString(string);
        }
    }

    public TXTRecord(Name name, short s, int n, Vector vector) throws IOException {
        super(name, (short)16, s, n);
        this.strings = vector;
    }

    public TXTRecord(Name name, short s, int n, String string) throws IOException {
        super(name, (short)16, s, n);
        this.strings = new Vector();
        this.strings.addElement(string);
    }

    TXTRecord(Name name, short s, int n, int n2, DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        super(name, (short)16, s, n);
        if (dataByteInputStream == null) {
            return;
        }
        int n3 = 0;
        this.strings = new Vector();
        while (n3 < n2) {
            byte by = dataByteInputStream.readByte();
            byte[] byArray = new byte[by];
            dataByteInputStream.read(byArray);
            n3 += by + 1;
            this.strings.addElement(new String(byArray));
        }
    }

    TXTRecord(Name name, short s, int n, MyStringTokenizer myStringTokenizer, Name name2) throws IOException {
        super(name, (short)16, s, n);
        this.strings = new Vector();
        while (myStringTokenizer.hasMoreTokens()) {
            this.strings.addElement(myStringTokenizer.nextToken());
        }
    }
}

