/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.Task;

import java.util.Vector;

public class WorkerThread
extends Thread {
    private static int nactive = 0;
    private static Vector list = new Vector();
    private static int max = 10;
    private static long lifetime = 900000L;
    private Runnable task;
    private String name;

    static synchronized void setLifetime(long l) {
        lifetime = l;
    }

    static synchronized void setMaxThreads(int n) {
        max = n;
    }

    static WorkerThread getThread() {
        WorkerThread workerThread;
        Vector vector = list;
        synchronized (vector) {
            if (list.size() > 0) {
                workerThread = (WorkerThread)list.firstElement();
                list.removeElement(workerThread);
            } else if (nactive >= max) {
                do {
                    try {
                        list.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (list.size() == 0);
                workerThread = (WorkerThread)list.firstElement();
                list.removeElement(workerThread);
            } else {
                workerThread = new WorkerThread();
            }
            ++nactive;
        }
        return workerThread;
    }

    public static void assignThread(Runnable runnable, String string) {
        while (true) {
            try {
                WorkerThread workerThread;
                WorkerThread workerThread2 = workerThread = WorkerThread.getThread();
                synchronized (workerThread2) {
                    workerThread.task = runnable;
                    workerThread.name = string;
                    if (!workerThread.isAlive()) {
                        workerThread.start();
                    } else {
                        workerThread.notify();
                    }
                }
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                continue;
            }
            break;
        }
    }

    public synchronized void run() {
        do {
            this.setName(this.name);
            try {
                this.task.run();
            }
            catch (Throwable throwable) {
                System.err.println(throwable);
            }
            this.setName("idle thread");
            Vector vector = list;
            synchronized (vector) {
                list.addElement(this);
                if (nactive >= max) {
                    list.notify();
                }
                --nactive;
            }
            this.task = null;
            try {
                this.wait(lifetime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.task != null);
        list.removeElement(this);
    }

    private WorkerThread() {
        this.setDaemon(true);
    }
}

