/*
 * Copyright (c) 2002 Jean-Baptiste Marchand, Herv Schauer Consultants.  
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Jean-Baptiste Marchand
 *	at Herv Schauer Consultants.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/* stolen from FreeBSD's netinet includes */

struct ip_hdr {
	u_char  ip_vhl;                 /* version << 4 | header length >> 2 */
	u_char  ip_tos;                 /* type of service */
    u_short ip_len;                 /* total length */
    u_short ip_id;                  /* identification */
    u_short ip_off;                 /* fragment offset field */
#define IP_RF 0x8000                /* reserved fragment flag */
#define IP_DF 0x4000                /* dont fragment flag */
#define IP_MF 0x2000                /* more fragments flag */
#define IP_OFFMASK 0x1fff           /* mask for fragmenting bits */
	u_char  ip_ttl;                 /* time to live */
	u_char  ip_p;                   /* protocol */
	u_short ip_sum;                 /* checksum */
	struct  in_addr ip_src,ip_dst;  /* source and dest address */
};

struct tcp_hdr {
        u_short th_sport;             /* source port */
        u_short th_dport;             /* destination port */
        u_int th_seq;                 /* sequence number */
        u_int th_ack;                 /* acknowledgement number */
        u_char th_x2_off;            /* data offset */
        u_char  th_flags;
#define TH_FIN  0x01
#define TH_SYN  0x02
#define TH_RST  0x04
#define TH_PUSH 0x08
#define TH_ACK  0x10
#define TH_URG  0x20
#define TH_ECE  0x40
#define TH_CWR  0x80
#define TH_FLAGS        (TH_FIN|TH_SYN|TH_RST|TH_ACK|TH_URG|TH_ECE|TH_CWR)
        u_short th_win;                 /* window */
        u_short th_sum;                 /* checksum */
        u_short th_urp;                 /* urgent pointer */
};

struct udp_hdr {
        u_short uh_sport;               /* source port */
        u_short uh_dport;               /* destination port */
        u_short uh_ulen;                /* udp length */
        u_short uh_sum;                 /* udp checksum */
};

struct icmp_hdr {
        u_char  icmp_type;              /* type of message, see below */
        u_char  icmp_code;              /* type sub code */
        u_short icmp_cksum;             /* ones complement cksum of struct */
};



/* stolen from ipmon.c (http://www.ipfilter.org/) */

#define ICMP_TYPES       19
static char *icmp_types[ICMP_TYPES] = {
        "echo-reply",
        NULL,
        NULL,
        "unreach",
        "source_quench",
        "redirect",
        NULL,
        NULL,
        "echo",
        "router_advert",
        "router_solicit",
        "time_exceeded",
        "param_prob",
        "timestamp",
        "timestamp-reply",
        "info-req",
        "info-reply",
        "mask-req",
        "mask-reply"
};

#define ICMP_UNREACH 3
#define ICMP_UNREACH_NAMES        16
static char *icmp_unreach_names[ICMP_UNREACH_NAMES] = {
        "net",
        "host",
        "protocol",
        "port",
        "need_frag",
        "src_fail",
        "net_unknown",
        "host_unknown",
        "isolated",
        "net_prohib",
        "host_prohib",
        "tos_net",
        "tos_host",
        "admin_prohibit",
		"host_preced_violation",
		"preced_cutoff"
};

#define ICMP_REDIRECT 5
#define ICMP_REDIRECT_NAMES 4
static char *icmp_redirect_names[ICMP_REDIRECT_NAMES] = {
		"net",
		"host",
		"tos_net",
		"tos_host"
};

#define ICMP_TIMEX 11
#define ICMP_TIMEX_NAMES 2
static char *icmp_timex_names[ICMP_TIMEX_NAMES] = {
		"in_transit",
		"reass"
};

#define ICMP_PARAM_PROB 12
#define ICMP_PARAM_PROB_NAMES 3
static char *icmp_param_prob_names[ICMP_PARAM_PROB_NAMES] = {
		"err_param_ptr",
		"opt_absent",
		"bad_length"
};