/*
 * Copyright (c) 2001 Jean-Baptiste Marchand, Herv Schauer Consultants.  
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Jean-Baptiste Marchand
 *	at Herv Schauer Consultants.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#define TCP_UDP_LOWEST_PORT 1
#define TCP_UDP_HIGHEST_PORT 65535

#define ANY_IP_ADDR  "\x00\x00\x00\x00"
#define ANY_MASK_ADDR "\x00\x00\x00\x00"
#define ANY_MASK 0xFFFFFFFF

/* list entry for all filters */
struct pf_filter {
	struct pf_filter *next;
	PF_FILTER_DESCRIPTOR *filter;
	struct pf_interface *iface; /* interface */
#define FILTER_PASS		(1 << 0)
#define FILTER_DROP		(1 << 1)
#define FILTER_IN		(1 << 2)
#define FILTER_OUT		(1 << 3)
	unsigned char filter_flags;
#define TCP_UDP_EQ_PORT		(1 << 0)
#define TCP_UDP_LT_PORT		(1 << 1)
#define TCP_UDP_GT_PORT		(1 << 2)
#define TCP_UDP_LE_PORT		(1 << 3)
#define TCP_UDP_GE_PORT 	(1 << 4)
#define TCP_UDP_INTERVAL_PORT 	(1 << 5)
	unsigned char src_flags;
	unsigned char dst_flags;
};


/* filtering data for interface */
struct pf_interface {
	struct pf_interface *next; 	/* next interface */
	unsigned char index;		/* interface index, ex. 0 for eth0 */
	DWORD system_index;         /* value of Index field in IP_ADAPTER_INFO */
	char name[6];				/* interface name, ex 'eth0'
	                               (built from Type and ComboIndex fields 
									in IP_ADAPTER_INFO) */
	INTERFACE_HANDLE ih;		/* handle to interface, returned by
								   PfCreateInterface */
	PFFORWARD_ACTION inAction;	/* default action for input packets */
	PFFORWARD_ACTION outAction;	/* default action for output packets */
	BOOL log;					/* logging */
#define IN_FILTERS_START 1 		/* start of the input rules numbers */
	struct pf_filter *inFilters;	/* pointer to list of input filters */
#define OUT_FILTERS_START 128		/* start of the output rules numbers */
	struct pf_filter *outFilters;	/* pointer to list of output filters */
	unsigned int inFiltersNo;	/* number of input filters */
	unsigned int outFiltersNo;	/* number of output filters */
	GLOBAL_FILTER small_frags;	/* reject small IP fragments */
#if 0
	GLOBAL_FILTER strong_host;	/* check destination address of incoming packets */
#endif /* GF_STRONGHOST */
#if 0
	GLOBAL_FILTER check_frags;	/* check consistency of IP fragments */
#endif /* GF_FRAGCACHE */
};

void client_printf(char *, ...);
