//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


//
// Define the severity codes
//


//
// MessageId: PKTFLT_CTLHDL_ERROR
//
// MessageText:
//
//  Failed to register service's control function.
//
#define PKTFLT_CTLHDL_ERROR              0xE0FF0001L

//
// MessageId: PKTFLT_READ_REGISTRY_KEY_ERROR
//
// MessageText:
//
//  Failed to read registry key "HKLM\System\CurrentControlSet\Services\PktFilter".
//
#define PKTFLT_READ_REGISTRY_KEY_ERROR   0xE0FF0002L

//
// MessageId: PKTFLT_READ_REGISTRY_RULES_FILE_ERROR
//
// MessageText:
//
//  Failed to read registry value "HKLM\System\CurrentControlSet\Services\PktFilter\RulesFile".
//
#define PKTFLT_READ_REGISTRY_RULES_FILE_ERROR 0xE0FF0003L

//
// MessageId: PKTFLT_LOAD_FILTERS_FAILED_ERROR
//
// MessageText:
//
//  Failed to load filters from the file with filename contained in the 
//  "HKLM\System\CurrentControlSet\Services\PktFilter\RulesFile" registry value.
//
#define PKTFLT_LOAD_FILTERS_FAILED_ERROR 0xE0FF0004L

//
// MessageId: PKTFLT_OPEN_FILTERS_FILE_FAILED_ERROR
//
// MessageText:
//
//  Failed to open filters file with filename contained in the 
//  "HKLM\System\CurrentControlSet\Services\PktFilter\RulesFile" registry value.
//
#define PKTFLT_OPEN_FILTERS_FILE_FAILED_ERROR 0xE0000005L

//
// MessageId: PKTFLT_RULE_SYNTAX_ERROR
//
// MessageText:
//
//  File containing filters with filename contained in the 
//  "HKLM\System\CurrentControlSet\Services\PktFilter\RulesFile" 
//  registry value has a syntax error:%n%1
//
#define PKTFLT_RULE_SYNTAX_ERROR         0xE0FF0006L

//
// MessageId: PKTFLT_CLIENT_PIPE_ERROR
//
// MessageText:
//
//  Communication with the client through named pipe failed
//
#define PKTFLT_CLIENT_PIPE_ERROR         0xE0FF0007L

//
// MessageId: PKTFLT_STARTING
//
// MessageText:
//
//  Stateless Packet Filtering service is starting
//
#define PKTFLT_STARTING                  0x60FF0008L

//
// MessageId: PKTFLT_STARTED
//
// MessageText:
//
//  Stateless Packet Filtering service has started
//
#define PKTFLT_STARTED                   0x60FF0009L

//
// MessageId: PKTFLT_RRAS_RUNNING
//
// MessageText:
//
//  RRAS service is running and may conflict with Stateless Packet Filtering service
//
#define PKTFLT_RRAS_RUNNING              0xA0FF000AL

//
// MessageId: PKTFLT_ALLOC_FAILED
//
// MessageText:
//
//  Could not allocate the buffer used to communicate with the client program
//
#define PKTFLT_ALLOC_FAILED              0xE0FF000BL

//
// MessageId: PKTFLT_READ_REGISTRY_LOG_FILE_ERROR
//
// MessageText:
//
//  Failed to read registry value "HKLM\System\CurrentControlSet\Services\PktFilter\LogFile".
//
#define PKTFLT_READ_REGISTRY_LOG_FILE_ERROR 0xE0FF000CL

