
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-04-21  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Moved all contents to Hostports function which takes an
#             additional parameter (accept|deny|ignore).
# 2001-04-17  Dougal Holmes <dholmes@bigpond.net.au>
#             Reversed direction for local ports for clusters
#             (as client options for clusters are for connections _to_
#             the cluster, and not to the interface address)
# 2001-03-28  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "tr" by To_Upper/To_Lower functions.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Accept_Hostports () {
	#
	# This function expects each host to have an accompanying port number.
	#
	# Syntax:
	#   Accept_Hostports [local|remote] {prot} {description} {hosts and ports}
	#
	# Examples:
	#   Accept_Hostports local tcp "HTTP" any/0 www
	#   Accept_Hostports local tcp "My Game" first.friend.com 1234:1240 1666, second.friend.com 1234
	#

	arg_1="`echo $1|To_Lower`"
	arg_2="$2"
	arg_3="$3"
	shift 3

	case "$arg_1" in
		local|remote)
			Hostports accept "$arg_1" "$arg_2" "$arg_3" $*
			;;
		*)	echo "Accept_Hostports [local|remote] {prot} {description} {hosts and ports}"
			return
			;;
	esac
}

