
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
# Return the netmask using the bit length. Thanks to Paolo Bonzini 
# <bonzini@pc-amo3.elet.polimi.it> for contributing the sed code for
# this function.
#
# Example: Bitlen_To_Netmask 28
# Returns: 255.255.255.240
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-30  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Function added to v5.1.1b2 development code.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Bitlen_To_Netmask () {

	[ "$1" ] && { expr $1 / 8; expr $1 % 8; } | sed -ne ' 
		1 { 
			# Add the right number of bytes set to 255  
			s/[1234]$/255.&/ 
			s/[234]$/255.&/ 
			s/[34]$/255.&/ 
			s/4$/255.&/ 
			s/.$// 
			h 
			d 
		} 
 
		2 {
			s/^1$/128/
			s/^2$/192/
			s/^3$/224/
			s/^4$/240/
			s/^5$/248/
			s/^6$/252/
			s/^7$/254/
			H
			g
			s/\n//
 
			# Pad and remove the excess bytes
			s/$/.0.0.0.0/
			s/\([0-9]*\.[0-9]*\.[0-9]*\.[0-9]*\).*/\1/p
		}
	'
}

