
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-19  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced all "cat" commands by Sed_Cat function.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Check_Old_Config_Paths () {

	for CUSTOM_FILE in ${CONF}.custom ${0}.custom-ports ${0}.custom-pub-ports ${0}.custom-pri-ports
	do
		if [ -r "$CUSTOM_FILE" ]
		then
			echo "$CUSTOM_FILE ignored!"
			echo "Version 5 no longer supports the $CUSTOM_FILE file."
		fi
	done

	if [ -r "${0}.conf" ]
	then
		if [ ! -r "$CONF" ]
		then
			FAILED="yes"
			Sed_Cat <<EOF

The configuration file has moved to ${CONF} since version 5.0.
Moving ${0}.conf to ${CONF}...
EOF
			mv "${0}.conf" "${CONF}"
		else
			Sed_Cat <<EOF

Both ${CONF} and ${0}.conf exist!
The correct configuration file path is ${CONF}.
Please remove the old ${0}.conf file.
EOF
		fi
	fi

	if [ -d "/etc/firewall-modules" ]
	then
		echo "WARNING: /etc/firewall-modules is no longer used."
	fi

	if [ "$FAILED" ]
	then
		echo -n "Pausing for $ERROR_PAUSE secs..."; sleep $ERROR_PAUSE; echo ""
		echo ""
		unset FAILED
	fi
}

