
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
# Chop a string at a specified position and swap the pieces.
#
# Syntax: echo "string to swap"|Chop_And_Swap {pos}
#
# In the following example, we use Chop_And_Swap to replace sort's -k
# parameter (sort -k 1.4 filename.txt).
#
# Example: cat filename.txt|Chop_And_Swap 4|sort|Unchop_And_Swap 4
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-19  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Function added to v5.1.1a10 development code.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Chop_And_Swap () { sed -n -e "s/^\(.\{`expr $1 - 1`\}\)\(.*\)$/\2\1/p"; }

Unchop_And_Swap () { sed -n -e "s/^\(.*\)\(.\{`expr $1 - 1`\}\)$/\2\1/p"; }

