
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-30  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Fixed missing ']' when testing for default value.
# 2001-03-28  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "tr" by To_Upper/To_Lower functions. Replaced
#             "expr STRING : EXPR" by "sed" command.
# 2001-03-23  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced do-while loop with sed command to right justify
#             option names.
# 2001-03-19  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "cat" command by Sed_Cat function.
# 2001-03-12  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Changed egrep commands to their grep equivalents.
#             Replaced awk command with sed, echo, etc. to print options
#             with leading spaces.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Config_Options () {
	#
	# $1: Actions (enable, accept, deny, etc.)
	# $2: Interface Type (private|public|real_private|real_public)
	# $3: Service (telnet, etc.)
	# $4: Type (servers, clients, hosts, etc.)
	# $5: Default Value (syntax: "action = value")
	#
	lcase_actions="`echo $1|To_Lower`"
	lcase_types="`echo $2|To_Lower`"

	rm -f ${CONF}.options.tmp
	touch ${CONF}.options.tmp
	chmod 600 ${CONF}.options.tmp
	
	max_option_len="0"

	for lcase_type in $lcase_types
	do
		if [ "`echo $2|grep '^real_'`" ]
		then
			only_real="yes"
			lcase_type="`echo $lcase_type|sed -e 's/^real_\(.*\)$/\1/'`"
		else
			only_real="no"
		fi

		ucase_type="`echo $lcase_type|To_Upper`"
		eval interfaces=\"\$${ucase_type}_INTERFACES\"
	
		for interface in $interfaces
		do
			# skip any virtual interface if necessary
			[ "`echo $interface|grep ':'`" -a "$only_real" = "yes" ] && continue
	
			ucase_interface="`echo $interface|To_Upper_Fix`"
	
			# check to see if cluster names have been defined for this interface
			eval cluster_names=\"\$${ucase_type}_${ucase_interface}_CLUSTER_NAMES\"
	
			interface_fields="$interface"
			for cluster_name in $cluster_names
			do
				interface_fields="$interface_fields ${interface}:${cluster_name}"
			done
	
			# For regular interfaces, the interface_fields variable contains only
			# a single interface name. For DMZs, the interface has been joined with
			# cluster names (i.e. "eth3:webservers eth3:ftpservers", etc.).
			#
			for interface_field in $interface_fields
			do
				cluster_match="`echo \"$interface_field\"|grep \"^${interface}:.*\$\"`"

				for action in $lcase_actions
				do
					# ******** skip forward actions for d/mz clusters ********
					[ "$action" = "forward" -a "$cluster_match" ] && continue
	
					var="`echo ${action}-${interface_field}-${3}-${4}|To_Lower_Fix`"
					rec="`echo ${action}_${interface_field}_${3}_${4}|To_Upper_Fix`"
			
					if [ ! "`Defined $rec`" \
						-a "`echo \"$5\"|sed -n -e \"s/^${action}_${lcase_type}  *=  *\(.*\)$/\1/p\"`" ]
					then
						default_value="`echo $5|sed -n -e "s/^${action}_${lcase_type}  *=  *\(.*\)$/\1/p\"`"
						eval : \${$rec:=\"$default_value\"}
					fi
	
					option_len="`Sed_Length $var`"
					[ "$option_len" -gt "$max_option_len" ] && max_option_len="$option_len"
	
					eval echo "${var}=\$${rec}" >> ${CONF}.options.tmp
				done
			done
		done
	done

	unset interface_fields interface_field
	unset interfaces interface cluster_names cluster_name
	unset lcase_actions lcase_types ucase_type
	unset default_value var rec option_len
	
	if [ "$max_option_len" -gt "0" ]
	then
		{
			sed -n -e '/=/{:a' -e "/^.\{${max_option_len}\}=/!s/^/ /;ta" -e '}' \
				-e 's/^\([^=]*\)=\([^=]*\)$/\1 = \2/p' ${CONF}.options.tmp
			echo ""
		} >> "${CONF}.tmp"
	fi
	rm -f ${CONF}.options.tmp
	unset max_option_len
}

