
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-28  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "tr" by To_Upper/To_Lower functions.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Convert_Options () {
	# ----------------------------------------------------------------------
	# Convert older variables (goes back to v1.0).
	# ----------------------------------------------------------------------
	# If the variable is not empty, save it's value into the new variable 
	# name. No matter what, unset the old variable.
	# ----------------------------------------------------------------------

	echo -n "Converting Options to v${VERSION}..."

	[ "$INT_INTERFACE" ] \
		&& INT_INTERFACES="$INT_INTERFACE"
		unset INT_INTERFACE

	[ "$EXT_INTERFACE" ] \
		&& EXT_INTERFACES="$EXT_INTERFACE"
		unset EXT_INTERFACE

	[ "$ACCEPT_EXT_JUNKBUSTER_CLIENTS" ] \
		&& ACCEPT_EXT_PROXY_CLIENTS="$ACCEPT_EXT_JUNKBUSTER_CLIENTS"
		unset ACCEPT_EXT_JUNKBUSTER_CLIENTS

	[ "$ACCEPT_EXT_PROXY_PORT" ] \
		&& ACCEPT_EXT_PROXY_PORTS="$ACCEPT_EXT_PROXY_PORT"
		unset ACCEPT_EXT_PROXY_PORT

	[ "$ACCEPT_EXT_BATTLENET_SERVERS" ] \
		&& ACCEPT_EXT_BATTLENET_HOSTS="$ACCEPT_EXT_BATTLENET_SERVERS"
		unset ACCEPT_EXT_BATTLENET_SERVERS

	[ "$ACCEPT_EXT_BATTLENET_HOSTS" ] \
		&& ACCEPT_EXT_BATTLENET_HOSTPORTS="$ACCEPT_EXT_BATTLENET_HOSTS $ACCEPT_EXT_BATTLENET_PORTS"
		unset ACCEPT_EXT_BATTLENET_HOSTS ACCEPT_EXT_BATTLENET_PORTS

	[ "$ACCEPT_EXT_DIRECTX_SERVERS" ] \
		&& ACCEPT_EXT_DIRECTX_HOSTS="$ACCEPT_EXT_DIRECTX_SERVERS"
		unset ACCEPT_EXT_DIRECTX_SERVERS

	[ "$ACCEPT_EXT_DIRECTX_HOSTS" ] \
		&& ACCEPT_EXT_DIRECTX_HOSTPORTS="$ACCEPT_EXT_DIRECTX_HOSTS $ACCEPT_EXT_DIRECTX_PORTS"
		unset ACCEPT_EXT_DIRECTX_HOSTS ACCEPT_EXT_DIRECTX_PORTS

	[ "$FORWARD_UDP_PORTS" ] \
		&& FORWARD_EXT_UDP_PORTS="$FORWARD_UDP_PORTS"
		unset FORWARD_UDP_PORTS

	[ "$FORWARD_TCP_PORTS" ] \
		&& FORWARD_EXT_TCP_PORTS="$FORWARD_TCP_PORTS"
		unset FORWARD_TCP_PORTS

	[ "$FORWARD_EXT_UDP_PORTS" ] \
		&& FORWARD_EXT_UDP_HOSTPORTS="$FORWARD_EXT_UDP_PORTS"
		unset FORWARD_EXT_UDP_PORTS

	[ "$FORWARD_EXT_TCP_PORTS" ] \
		&& FORWARD_EXT_TCP_HOSTPORTS="$FORWARD_EXT_TCP_PORTS"
		unset FORWARD_EXT_TCP_PORTS

	# ----------------------------------------------------------------------
	# 4.1 -> 5.0
	# ----------------------------------------------------------------------

	[ "$INT_INTERFACES" ] \
		&& PRI_INTERFACES="$INT_INTERFACES"
		unset INT_INTERFACES

	[ "$PRI_INTERFACES" ] \
		&& PRIVATE_INTERFACES="$PRI_INTERFACES"
		unset PRI_INTERFACES

	[ "$EXT_INTERFACES" ] \
		&& PUB_INTERFACES="$EXT_INTERFACES"
		unset EXT_INTERFACES

	[ "$PUB_INTERFACES" ] \
		&& PUBLIC_INTERFACES="$PUB_INTERFACES"
		unset PUB_INTERFACES

	[ "$ACCEPT_EXT_MULTICAST_IGMP_SERVERS" ] \
		&& ACCEPT_EXT_MCASTIGMP_SERVERS="$ACCEPT_EXT_MULTICAST_IGMP_SERVERS"
		unset ACCEPT_EXT_MULTICAST_IGMP_SERVERS

	[ "$ACCEPT_EXT_IPSEC_VPN_HOSTS" ] \
		&& ACCEPT_EXT_IPSECVPN_HOSTS="$ACCEPT_EXT_IPSEC_VPN_HOSTS"
		unset ACCEPT_EXT_IPSEC_VPN_HOSTS

	[ "$ACCEPT_EXT_SMB_CLIENTS" ] \
		&& ACCEPT_EXT_SMB_HOSTS="$ACCEPT_EXT_SMB_CLIENTS"
		unset ACCEPT_EXT_SMB_CLIENTS

	[ "$LOG_DENIED_DHCP_INPUT" ] \
		&& unset LOG_DENIED_DHCP_INPUT

	[ "$IP_MASQ_MODULE" ] \
		&& IP_MASQ_MODULES="$IP_MASQ_MODULE"
		unset IP_MASQ_MODULE

	[ "$IP_MASQ_TIMEOUT" ] \
		&& IP_MASQ_TIMEOUTS="$IP_MASQ_TIMEOUT"
		unset IP_MASQ_TIMEOUT

	FW_4_1_EXT_VARS="\
		DENY_EXT_BLACKLIST_HOSTS \
		ACCEPT_EXT_SMB_HOSTS \
		ACCEPT_EXT_IPSECVPN_HOSTS \
		ACCEPT_EXT_DHCP_SERVERS ACCEPT_EXT_FTPACTV_SERVERS \
		ACCEPT_EXT_ICQ_SERVERS ACCEPT_EXT_MCASTIGMP_SERVERS \
		ACCEPT_EXT_NTP_SERVERS ACCEPT_EXT_PRINTER_SERVERS \
		ACCEPT_EXT_SQUIDICP_SERVERS ACCEPT_EXT_SYSLOG_SERVERS \
		ACCEPT_EXT_AUTH_CLIENTS ACCEPT_EXT_CVSPSERVER_CLIENTS \
		ACCEPT_EXT_DNS_CLIENTS ACCEPT_EXT_FTPACTV_CLIENTS \
		ACCEPT_EXT_FTPPASV_CLIENTS ACCEPT_EXT_FINGER_CLIENTS \
		ACCEPT_EXT_HTTP_CLIENTS DENY_EXT_HTTP_CLIENTS \
		ACCEPT_EXT_HTTPS_CLIENTS DENY_EXT_HTTPS_CLIENTS \
		ACCEPT_EXT_ICQFILETRANS_CLIENTS ACCEPT_EXT_ICQFILETRANS_PORTS \
		ACCEPT_EXT_IMAP2_CLIENTS ACCEPT_EXT_NFS_CLIENTS \
		ACCEPT_EXT_NNTP_CLIENTS ACCEPT_EXT_PING_CLIENTS \
		ACCEPT_EXT_POP3_CLIENTS ACCEPT_EXT_PROXY_CLIENTS \
		ACCEPT_EXT_PROXY_PORTS \
		ACCEPT_EXT_SMTP_CLIENTS DENY_EXT_SMTP_CLIENTS \
		ACCEPT_EXT_SSH_CLIENTS ACCEPT_EXT_SIMAP_CLIENTS \
		ACCEPT_EXT_SPOP3_CLIENTS ACCEPT_EXT_TELNET_CLIENTS \
		ACCEPT_EXT_BATTLENET_HOSTPORTS FORWARD_EXT_BATTLENET_HOSTPORTS \
		ACCEPT_EXT_DIRECTX_HOSTPORTS FORWARD_EXT_DIRECTX_HOSTPORTS \
		ACCEPT_EXT_UNREALTOURNAMENT_HOSTPORTS FORWARD_EXT_UNREALTOURNAMENT_HOSTPORTS \
		ACCEPT_EXT_HALFLIFE_HOSTPORTS FORWARD_EXT_HALFLIFE_HOSTPORTS \
		FORWARD_EXT_UDP_HOSTPORTS FORWARD_EXT_TCP_HOSTPORTS \
		ACCEPT_EXT_UDP_HOSTPORTS ACCEPT_EXT_TCP_HOSTPORTS
	"

	for VAR in $FW_4_1_EXT_VARS
	do
		eval VALUE="\$${VAR}"
		if [ "$VALUE" ]
		then
			for INTERFACE in $PUBLIC_INTERFACES
			do
				INTERFACE="`echo $INTERFACE|To_Upper_Fix`"
				# Change the "EXT" part into "ETH1" (for example).
				NEW_VAR=`echo $VAR|sed -n -e "s/^\([A-Z]*\)_EXT_\([A-Z0-9_]*\)\$/\1_${INTERFACE}_\2/p"`
				# Make sure you don't over-ride an existing variable.
				eval : \${${NEW_VAR}:=\"\$${VAR}\"}
			done
		fi
		eval unset $VAR
	done
	unset FW_4_1_EXT_VARS VAR NEW_VAR VALUE INTERFACE
	echo ""

	# ----------------------------------------------------------------------
	# 5.0 -> 5.0.1
	# ----------------------------------------------------------------------

	for INTERFACE in $PUBLIC_INTERFACES
	do
		for TRANSFORM in \
			"accept-${INTERFACE}-icqfiletrans-clients->accept-${INTERFACE}-icqdirect-hosts" \
			"accept-${INTERFACE}-icqfiletrans-ports->accept-${INTERFACE}-icqdirect-ports" \
		;
		do
			OLD_OPTION="`echo $TRANSFORM|sed -n -e 's/^\(.*\)->\(.*\)/\1/p'`"
			NEW_OPTION="`echo $TRANSFORM|sed -n -e 's/^\(.*\)->\(.*\)/\2/p'`"

			OLD_VAR="`echo ${OLD_OPTION}|To_Upper_Fix`"
			NEW_VAR="`echo ${NEW_OPTION}|To_Upper_Fix`"

			eval [ "\$${OLD_VAR}" ] && eval ${NEW_VAR}="\$${OLD_VAR}"
			eval unset ${OLD_VAR}
		done
	done
	unset INTERFACE TRANSFORM OLD_OPTION NEW_OPTION OLD_VAR NEW_VAR

	# ----------------------------------------------------------------------
	# 5.0.1 -> 5.1
	# ----------------------------------------------------------------------

	[ "$MODE" ] \
		&& PUBLIC_INTERFACES_SECURITY="$MODE"
		unset MODE

	[ "$IP_MASQ_MODULES" ] \
		&& MASQ_MODULES="$IP_MASQ_MODULES"
		unset IP_MASQ_MODULES

	[ "$IP_MASQ_TIMEOUTS" ] \
		&& MASQ_TIMEOUTS="$IP_MASQ_TIMEOUTS"
		unset IP_MASQ_TIMEOUTS

	for interface in $PUBLIC_INTERFACES
	do
		ucase_interface="`echo $interface|To_Upper_Fix`"

		for transform in \
			"accept-${interface}-icqfiletrans-hosts->accept-${interface}-icqdirect-clients" \
		;
		do
			old_option="`echo $transform|sed -n -e 's/^\(.*\)->\(.*\)/\1/p'`"
			new_option="`echo $transform|sed -n -e 's/^\(.*\)->\(.*\)/\2/p'`"

			old_var="`echo ${old_option}|To_Upper_Fix`"
			new_var="`echo ${new_option}|To_Upper_Fix`"

			eval [ "\$${old_var}" ] && eval ${new_var}="\$${old_var}"
			eval unset ${old_var}
		done
	done
	unset interface ucase_interface transform old_option new_option old_var new_var
	
	# ----------------------------------------------------------------------
	# 5.1 -> 5.1.1
	# ----------------------------------------------------------------------

	for interface in $PUBLIC_INTERFACES $PRIVATE_INTERFACES $DMZ_INTERFACES $MZ_INTERFACES
	do
		ucase_interface="`echo $interface|To_Upper_Fix`"

		for transform in \
			"accept-${interface}-ping-clients->accept-${interface}-icmp-clients" \
		;
		do
			old_option="`echo $transform|sed -n -e 's/^\(.*\)->\(.*\)/\1/p'`"
			new_option="`echo $transform|sed -n -e 's/^\(.*\)->\(.*\)/\2/p'`"

			old_var="`echo ${old_option}|To_Upper_Fix`"
			new_var="`echo ${new_option}|To_Upper_Fix`"

			eval [ "\$${old_var}" ] && eval ${new_var}="\$${old_var}"
			eval unset ${old_var}
		done
	done
	unset interface ucase_interface transform old_option new_option old_var new_var
}

