#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
# When packets come in on an interface, but their destination is the IP
# of another interface, send the packet to the destination interface's 
# input chain. This prevents one interface's input rules from over-
# riding the access of another.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-11  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Used insert instead of append mode for chains. Added
#             description in function and improved screen output.
#             Created second shell function to re-use code.
# 2001-03-08  Vladimir Smelhaus <smelhaus@bpt.cz>
#             Initial function file written for rcf version 5.1
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Cross_Interface_Access () {

	# private/mz/dmz -> private/mz/dmz/public
	for FIRST_INTERFACE in $PRIVATE_INTERFACES $MZ_INTERFACES $DMZ_INTERFACES
	do
		for SECOND_INTERFACE in $PRIVATE_INTERFACES $MZ_INTERFACES $DMZ_INTERFACES $PUBLIC_INTERFACES
		do
			Cross_Interface_Access_Chain
		done
    done

	# public -> dmz/public
	for FIRST_INTERFACE in $PUBLIC_INTERFACES
	do
		for SECOND_INTERFACE in $DMZ_INTERFACES $PUBLIC_INTERFACES
		do
			Cross_Interface_Access_Chain
		done
	done
}

Cross_Interface_Access_Chain () {

	Get_Interface_Vars $FIRST_INTERFACE FIRST
	Get_Interface_Vars $SECOND_INTERFACE SECOND

	if [ "$FIRST_DEVICE" != "$SECOND_DEVICE" -a "$FIRST_VIRTUAL" = "no" ]
	then
		echo "Inserting $FIRST_INCHAIN -> $SECOND_INCHAIN Jump for any/0 -> $SECOND_IPADDR $LOG_MSG"
		ipchains -I $FIRST_INCHAIN -j $SECOND_INCHAIN -d $SECOND_IPADDR $LOG
	fi
}

