
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
# Examine routing table and determine which networks are being routed 
# through this interface. Also add our own network/netmask and remove
# duplicates.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-25  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Following a suggestion by Dougal Holmes, I added routes to
#             hosts when parsing the routing table, and removed
#             255.255.255.255 routes. While I was making these changes
#             I also replaced the grep command with a stricter sed
#             expression. Virtual interface IPs (gateway 0.0.0.0 and
#             netmask of 255.255.255.255) are also filtered.
# 2001-03-07  Jean-Sebastien Morisset <jsmoriss@mvlan.net> and
#             Edwin ten Brink <edwin@privateer.student.utwente.nl>
#             Changed egrep command to grep. Changed awk command
#             to sed equivalent.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Device_Subnets () {

	[ "$1" ] && prefix="${1}_" || prefix=""

	eval device=\"\$${prefix}DEVICE\"
	eval network=\"\$${prefix}NETWORK\"
	eval netmask=\"\$${prefix}NETMASK\"

	[ "$device" ] && {
		[ "$network" -a "$netmask" ] && echo "$network/$netmask"

		# Extract the network, gateway, and netmask for this interface.
		# Remove the default route and broadcast address (255.255.255.255).
		# Lastly, if the gateway is 0.0.0.0 and the netmask is 255.255.255.255,
		# remove this entry since it's probably a virtual interface IP.
		#
		netstat -nre 2>/dev/null | \
			sed -n -e "s/^\([0-9\.]*\)  *\([0-9\.]*\)  *\([0-9\.]*\)  *U[HG]*  *[0-9]*  *[0-9]*  *[0-9]*  *${device}$/\1 \2 \3/p" | \
			grep -v '^\(0\.0\.0\.0\|255\.255\.255\.255\) ' | \
			grep -v '^[0-9\.]* 0\.0\.0\.0 255\.255\.255\.255$' | \
			sed -n -e 's/^\([0-9\.]*\) [0-9\.]* \([0-9\.]*\)$/\1\/\2/p'
	} | sort | Sed_Uniq

	unset prefix device network netmask
}

