
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-25  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Following Dougal Holmes' suggestion, I added the DIRECTION
#             variable to prevent duplicate forwarding rules.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Forward_Interfaces () {

	# Prevent duplicate entries when using something like:
	# Forward_Interfaces "eth0 eth1" "eth0 eth1"
	[ "$1" = "$2" ] && DIRECTION="->" || DIRECTION="<->"

	for FIRST_INTERFACE in $1
	do
		Get_Interface_Vars $FIRST_INTERFACE FIRST
		for SECOND_INTERFACE in $2
		do
			Get_Interface_Vars $SECOND_INTERFACE SECOND
			if [ "$FIRST_INTERFACE" != "$SECOND_INTERFACE" \
				-a "$FIRST_VIRTUAL" = "no" -a "$SECOND_VIRTUAL" = "no" ]
			then
				for FIRST_NET in `Device_Subnets FIRST`
				do
					for SECOND_NET in `Device_Subnets SECOND`
					do
						Forward_Subnets "${FIRST_NET}${DIRECTION}${SECOND_NET}"
					done
				done
			fi
		done
	done

	unset DIRECTION
}

