
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-28  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "expr index" commands with "sed".
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Forward_Subnets () {

	for subnet_pair in $*
	do
		first_subnet="`echo \"$subnet_pair\"|sed -n -e 's/\([^<]*\)\(<*\->*\)\(.*\)/\1/p'`"
		forward_behavior="`echo \"$subnet_pair\"|sed -n -e 's/\([^<]*\)\(<*\->*\)\(.*\)/\2/p'`"
		second_subnet="`echo \"$subnet_pair\"|sed -n -e 's/\([^<].*\)\(<*\->*\)\(.*\)/\3/p'`"

		if [ "$first_subnet" -a "$second_subnet" -a "$first_subnet" != "$second_subnet" ]
		then
			echo "Forward $first_subnet $forward_behavior $second_subnet $LOG_MSG"
			[ "`echo \"$forward_behavior\"|sed -n -e 's/^.*\(>\).*$/\1/p'`" ] \
				&& ipchains -A forward -j ACCEPT -s $first_subnet -d $second_subnet $LOG
			[ "`echo \"$forward_behavior\"|sed -n -e 's/^.*\(<\).*$/\1/p'`" ] \
				&& ipchains -A forward -j ACCEPT -s $second_subnet -d $first_subnet $LOG
		fi
	done
	unset subnet_pair first_subnet second_subnet forward_behavior
}

