
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-28  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "tr" by To_Upper/To_Lower functions.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Get_Cluster_Vars () {
	DEVICE="`echo $1|sed -n -e 's/^\([^\:]*\).*$/\1/p'`"
	[ "$DEVICE" != "$1" ] && VIRTUAL="yes" || VIRTUAL="no"

	ucase_interface="`echo $1|To_Upper_Fix`"

	NETADDR="$2"
	IPADDR="$2"
	eval \
		NETMASK=\"\$${ucase_interface}_NETMASK\" \
		NETWORK=\"\$${ucase_interface}_NETWORK\" \
		BROADCAST=\"\$${ucase_interface}_BROADCAST\" \
		INCHAIN=\"\$${ucase_interface}_INCHAIN\" \
		OUTCHAIN=\"\$${ucase_interface}_OUTCHAIN\"

	unset ucase_interface
}

