
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-30  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "tr" by To_Upper/To_Lower functions. Added the
#             BITLEN variable.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Get_Interface_Vars () {
	if [ "$1" ]
	then
		ucase_interface=`echo $1|To_Upper_Fix`
		[ "$2" ] && prefix="${2}_" || prefix=""

		device="`echo $1|sed -n -e 's/^\([^\:]*\).*\$/\1/p'`"
		[ "$device" != "$1" ] && virtual="yes" || virtual="no"

		eval \
			${prefix}INTOPT="$1" \
			${prefix}DEVICE="$device" \
			${prefix}VIRTUAL="$virtual" \
			${prefix}NETADDR=\"\$${ucase_interface}_IPADDR\" \
			${prefix}IPADDR=\"\$${ucase_interface}_IPADDR\" \
			${prefix}BITLEN=\"\$${ucase_interface}_BITLEN\" \
			${prefix}NETMASK=\"\$${ucase_interface}_NETMASK\" \
			${prefix}NETWORK=\"\$${ucase_interface}_NETWORK\" \
			${prefix}BROADCAST=\"\$${ucase_interface}_BROADCAST\" \
			${prefix}INCHAIN=\"\$${ucase_interface}_INCHAIN\" \
			${prefix}OUTCHAIN=\"\$${ucase_interface}_OUTCHAIN\"

		unset ucase_interface prefix device virtual
	else
		echo "ERROR: Get_Interface_Vars function needs at least one argument!"
	fi
}

