
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

High_Port_Rules () {

	INTERFACE_TYPE="$1"
	INTERFACE_MODE="$2"

	#--------------------------------------------------------------------
	# HIGH PORTS (Port 1024-65535)
	#--------------------------------------------------------------------

	if [ "$INTERFACE_MODE" -ge "1" ]
	then
		# In "strict" and "relaxed" modes, allow outgoing TCP traffic (and their replies).
		if [ "$INTERFACE_MODE" -le "2" ]
		then
			if [ "$CLUSTER_NAME" ]
			then
				echo "Accept $INTOPT $NETADDR Port# $UNPRIVPORTS/tcp -> $ANY $LOG_MSG"
				ipchains -A $INCHAIN  -j ACCEPT -p tcp -s $NETADDR $UNPRIVPORTS -d $ANY $LOG
				echo "Accept $INTOPT $NETADDR Port# $UNPRIVPORTS/tcp <- $ANY (replies only) $LOG_MSG"
				ipchains -A $OUTCHAIN -j ACCEPT -p tcp ! -y -s $ANY -d $NETADDR $UNPRIVPORTS $LOG
			else
				echo "Accept $INTERFACE $NETADDR Port# $UNPRIVPORTS/tcp -> $ANY $LOG_MSG"
				ipchains -A $OUTCHAIN -j ACCEPT -p tcp -s $NETADDR $UNPRIVPORTS -d $ANY $LOG
				echo "Accept $INTERFACE $NETADDR Port# $UNPRIVPORTS/tcp <- $ANY (replies only) $LOG_MSG"
				ipchains -A $INCHAIN  -j ACCEPT -p tcp ! -y -s $ANY -d $NETADDR $UNPRIVPORTS $LOG
			fi

			# In "relaxed" mode, allow incoming/outgoing UDP packets to/from high ports.
			if [ "$INTERFACE_MODE" -eq "1" ]
			then
				if [ "$CLUSTER_NAME" ]
				then
					echo "Accept $INTOPT $NETADDR Port# $UNPRIVPORTS/udp <-> $ANY $LOG_MSG"
					ipchains -A $OUTCHAIN -j ACCEPT -p udp -s $ANY -d $NETADDR $UNPRIVPORTS $LOG
					ipchains -A $INCHAIN  -j ACCEPT -p udp -s $NETADDR $UNPRIVPORTS -d $ANY $LOG
				else
					echo "Accept $INTERFACE $NETADDR Port# $UNPRIVPORTS/udp <-> $ANY $LOG_MSG"
					ipchains -A $INCHAIN  -j ACCEPT -p udp -s $ANY -d $NETADDR $UNPRIVPORTS $LOG
					ipchains -A $OUTCHAIN -j ACCEPT -p udp -s $NETADDR $UNPRIVPORTS -d $ANY $LOG
				fi
			fi
		fi

		# Clusters cannot deny traffic to their range of IPs. Sub-clusters
		# which may come afterwards would have their rules blocked by
		# this one.
		#
		if [ ! "$CLUSTER_NAME" ]
		then
			echo "Reject/Deny $DEVICE $NETADDR <-> $ANY (logged)"
			ipchains -A $INCHAIN  -j DENY   -s $ANY -d $NETADDR -l
			ipchains -A $OUTCHAIN -j REJECT -s $NETADDR -d $ANY -l
		fi
	fi

	unset INTERFACE_TYPE INTERFACE_MODE
}

