
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
# Special user chain for checking IANA reserved networks.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-23  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Removed forced logging from RETURN command.
# 2001-03-22  Vladimir Smelhaus <smelhaus@bpt.cz>
#             Special user chain for checking IANA reserved networks.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Iana_Networks_Chains () {

	if [ "$IANA_RESERVED_NETWORKS" ]
	then
		echo "Creating ianai Chains and Adding Deny Rules"

		ipchains -N ianai
		for reserved_network in $IANA_RESERVED_NETWORKS
		do
		    ipchains -A ianai -j DENY -p all -s $reserved_network -d $ANY -l
		done
		unset reserved_network
		####ipchains -A ianai -j RETURN $LOG
	fi
}

