
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-04-12  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Added test for dhcp clients option before denying incoming
#             dhcp broadcasts.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Illegal_Malformed_Address_Rules () {

	if [ "$VIRTUAL" = "no" ]
	then
		# ICMP TYPES
		#
		#  0 = echo-reply
		#  3 = destination-unreachable
		#  4 = source-quench
		#  5 = redirect
		#  8 = echo-request
		# 11 = time-exceeded
		# 12 = parameter-problem

		echo "Deny/Reject $INTERFACE ICMP Smurf Attacks (logged)"
		ipchains -A $INCHAIN  -j DENY   -p icmp -d $BROADCAST_DEST -l
		ipchains -A $OUTCHAIN -j REJECT -p icmp -d $BROADCAST_DEST -l

		ipchains -A $INCHAIN  -j DENY   -p icmp -d $NETMASK -l
		ipchains -A $OUTCHAIN -j REJECT -p icmp -d $NETMASK -l

		# Deny ICMP packets to network address (example: 24.200.96.0).
		# Make sure the network address isn't equal to our IP (just in case).
		#
		if [ "$NETWORK" != "$IPADDR" ]
		then
			ipchains -A $INCHAIN  -j DENY   -p icmp -d $NETWORK -l
			ipchains -A $OUTCHAIN -j REJECT -p icmp -d $NETWORK -l
		fi

		echo "Deny $INTERFACE Malformed Broadcast Packets (logged)"
		ipchains -A $INCHAIN -j DENY -s $BROADCAST_DEST -l
		ipchains -A $INCHAIN -j DENY -d $BROADCAST_SRC -l

		# Multicast is only valid as destination IP.
		#
		echo "Deny $INTERFACE Multicast as Source (logged)"
		ipchains -A $INCHAIN  -j DENY   -s $CLASS_D_MULTICAST -l
		ipchains -A $OUTCHAIN -j REJECT -s $CLASS_D_MULTICAST -l
	
		# If someone is offering multicast services, we'll have to change this.
		#
		echo "Deny $INTERFACE All Outbound Multicast (logged)"
		ipchains -A $OUTCHAIN -j REJECT -d $CLASS_D_MULTICAST -l

		####echo "Deny $INTERFACE Multicast (OSPF) <- $ANY $LOG_MSG"
		####ipchains -A $INCHAIN -j DENY -p 89 -s $ANY -d $CLASS_D_MULTICAST $LOG

		for host in `Option_Value accept $INTERFACE mcastigmp servers`
		do
			echo "Accept $INTERFACE IGMP Multicast <- $host $LOG_MSG"
			ipchains -A $INCHAIN -j ACCEPT -p igmp -s $host -d $CLASS_D_MULTICAST $LOG
		done
		unset host

		echo "Deny $INTERFACE All Multicast <- $ANY $LOG_MSG"
		ipchains -A $INCHAIN -j DENY -d $CLASS_D_MULTICAST $LOG

		# if we don't have any dhcp clients on this interface, block 
		# incoming dhcp broadcasts from clients.
		if [ ! "`Option_Value accept $INTOPT dhcp clients`" ]
		then
			echo "Deny $INTERFACE Stray BOOTPC $LOG_MSG"
			ipchains -A $INCHAIN -j DENY -p udp -s $ANY bootpc $LOG
		fi

		# RIP: Deny all stray RIP traffic. Many improperly configured networks
		# propagate network routing protocols to the edge of the network. The 
		# follow line will allow you explicitly filter it here without logging 
		# to SYSLOG.
		#
		echo "Deny $INTERFACE Stray RIP $LOG_MSG"
		ipchains -A $INCHAIN -j DENY -p udp -s $ANY -d $ANY 520 $LOG
	fi
}

