
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-31  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Optimized function by adding checks for filenames within
#             the whole option variable (instead of field by field).
# 2001-03-28  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "tr" by To_Upper/To_Lower functions. Replaced
#             "expr" command by "sed".
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Include_Group () {

	OPTION="`echo $1|To_Upper_Fix`"
	eval VALUE=\"\$$OPTION\"

	# skip options we know don't contain a group spec.
	[ "$VALUE" ] && if [ "`echo $VALUE|sed -ne 's/^.*\([ \.]\/\).*$/\1/p'`" ]
	then
		SEARCH_FOR_GROUP="1"	# search option at least once
		while [ "$SEARCH_FOR_GROUP" -gt "0" ]
		do
			SEARCH_FOR_GROUP="0"	# don't search again unless we reset this variable
			for FIELD in $VALUE
			do
				if [ "`echo $FIELD|sed -ne 's/^\(\/\).*$/\1/p'`" ]
				then
					FILENAME="${FIELD}"
				elif [ "`echo $FIELD|sed -ne 's/^\(\.\/\).*$/\1/p'`" ]
				then
					FILENAME="${GROUP_DIR}/`echo $FIELD|sed -e 's/^\.\///'`"
				fi
	
				[ "$FILENAME" ] && \
					if [ -f "$FILENAME" ]
					then
						echo "Adding `Sed_Basename $FILENAME` group to $OPTION"
						FIELD="`sed -ne 's/^\([^# ]*\).*$/\1/p' $FILENAME`"
						# search again if we find another file spec.
						[ "`echo $FIELD|sed -ne 's/^.*\([ \.]\/\).*$/\1/p'`" ] && SEARCH_FOR_GROUP="1"
					else
						echo "WARNING: Unable to read $FILENAME"
						echo "         group into $OPTION option!"
						FIELD=""
					fi
				unset FILENAME
				[ "$NEW_VALUE" ] && NEW_VALUE="$NEW_VALUE $FIELD" || NEW_VALUE="$FIELD"
			done
			# reset variable for next search
			VALUE="$NEW_VALUE"
			unset NEW_VALUE
		done
		eval $OPTION=\"$VALUE\"
		unset SEARCH_FOR_GROUP FIELD
	fi
	unset OPTION VALUE
}

