
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
# Using ifconfig or ip, return the ip address, netmask, etc. for an 
# interface.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-04-16  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Added Interface_Up function.
# 2001-04-02  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Added support for ifconfig _back_ into these functions.
# 2001-03-30  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Function added to v5.1.1b2 development code.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

All_Interfaces () {
	if [ "`which ifconfig 2>/dev/null`" ]
	then
		ifconfig -a|sed -ne 's/^\([^ ][^ ]*\).*$/\1/p'|sort
	elif [ "`which ip 2>/dev/null`" ]
	then
		ip addr show|sed -ne 's/^  *inet .* scope .* \([^ ]*\)$/\1/p'|sort
	fi
}

Interface_Addr () {
	if [ "$1" ]
	then
		if [ "`which ifconfig 2>/dev/null`" ]
		then
			ifconfig $1|sed -ne 's/.* addr:\([0-9\.]*\) .*/\1/p'
		elif [ "`which ip 2>/dev/null`" ]
		then
			ip addr show|sed -ne "s/  *inet \([0-9][0-9\.]*\).*\/\([0-9][0-9]*\) .* ${1}$/\1/p"
		fi
	fi
}

Interface_Bitlen () {
	if [ "$1" -a "`which ip 2>/dev/null`" ]
	then
		ip addr show|sed -ne "s/  *inet \([0-9][0-9\.]*\).*\/\([0-9][0-9]*\) .* ${1}$/\2/p"
	fi
}

Interface_Netmask () {
	if [ "$1" -a "`which ifconfig 2>/dev/null`" ]
	then
		ifconfig $1|sed -ne 's/.* Mask:\([0-9\.]*\)$/\1/p'
	fi
}

Interface_Broadcast () {
	if [ "$1" -a "`which ifconfig 2>/dev/null`" ]
	then
		ifconfig $1|sed -ne 's/.* Bcast:\([0-9\.]*\) .*/\1/p'
	fi
}

Interface_Up () {
	if [ "$1" ]
	then
		if [ "`Interface_Addr $1`" ]
		then
			device="`echo $1|sed -n -e 's/^\([^\:]*\).*\$/\1/p'`"
			if [ "`which ifconfig 2>/dev/null`" ]
			then
				ifconfig $1|sed -ne 's/^.* \(UP\) .*$/\1/p'
			elif [ "`which ip 2>/dev/null`" ]
			then
				ip addr show $device|sed -ne "s/^.*UP.*$/\1/p"
			fi
		fi
	fi
}

