
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-19  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Removed "wc" command. Replaced "cat" commands by
#             Sed_Cat function.
# 2001-02-12  Edwin ten Brink <edwin@privateer.student.utwente.nl>
#             Cosmetic changes. Prepared function for port to LRP.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Ipv4_Check () {
	echo "Checking IPv4 Configuration..."

	for FILENAME in \
		icmp_echo_ignore_all \
		icmp_echo_ignore_broadcasts \
		icmp_ignore_bogus_error_responses \
		icmp_destunreach_rate \
		icmp_echoreply_rate \
		icmp_paramprob_rate \
		icmp_timeexceed_rate \
		ip_always_defrag \
		ip_dynaddr \
		tcp_rfc1337 \
		tcp_syncookies
	do
		FILEPATH="/proc/sys/net/ipv4/${FILENAME}"

		if [ -w $FILEPATH ]
		then
			case $FILENAME in
				icmp_echo_ignore_all)			VALUE="0" ;;
				icmp_echo_ignore_broadcasts)		VALUE="1" ;;
				icmp_destunreach_rate)			VALUE="100" ;;
				icmp_echoreply_rate)			VALUE="100" ;;
				icmp_paramprob_rate)			VALUE="100" ;;
				icmp_timeexceed_rate)			VALUE="100" ;;
				icmp_ignore_bogus_error_responses) 	VALUE="1" ;;
				ip_always_defrag)			VALUE="1" ;;
				ip_dynaddr)				VALUE="1" ;;
				tcp_rfc1337)				VALUE="1" ;;
				tcp_syncookies)				VALUE="1" ;;
				*)	: ;;
			esac
			[ "$VALUE" ] && if [ "`Sed_Cat $FILEPATH`" -ne "$VALUE" ]
			then
				case $FILENAME in
					icmp_echo_ignore_all)			echo "Disabling Ignore of All ICMP Packets" ;;
					icmp_echo_ignore_broadcasts)		echo "Enabling ICMP Ignore Broadcasts" ;;
					icmp_destunreach_rate)			echo "Setting ICMP Destination Unreachable Rate to ${VALUE}" ;;
					icmp_echoreply_rate)			echo "Setting ICMP Echo Reply Rate to ${VALUE}" ;;
					icmp_paramprob_rate)			echo "Setting ICMP Parameter Problem Rate to ${VALUE}" ;;
					icmp_timeexceed_rate)			echo "Setting ICMP Time Exceeded Rate to ${VALUE}" ;;
					icmp_ignore_bogus_error_responses)	echo "Enabling ICMP Ignore Bogus Error Response" ;;
					ip_always_defrag)			echo "Enabling IP Defragmentation" ;;
					ip_dynaddr)				echo "Enabling Dynamic TCP/IP Address Hacking" ;;
					tcp_rfc1337)				echo "Disabling TIME-WAIT Assassination Hazards" ;;
					tcp_syncookies)				echo "Enabling TCP SYN Cookie Protection" ;;
					*)
						case $VALUE in
							0)	echo "Disabling \"${FILENAME}\" Setting" ;;
							1)	echo "Enabling \"${FILENAME}\" Setting" ;;
						esac
						;;
				esac
				[ "$TEST" ] \
					&& echo "	echo \"${VALUE}\" >$FILEPATH" >>/dev/stderr \
					|| echo "${VALUE}" >$FILEPATH
			fi
		elif [ ! -w $FILEPATH ]
		then
			echo -n "WARNING: "
			case $FILENAME in	
				icmp_echo_ignore_broadcasts)		echo "Please enable ICMP Ignore Broadcasts in your kernel!" ;;
				icmp_ignore_bogus_error_responses)	echo "Please enable ICMP Ignore Bogus Response in your kernel!" ;;
				ip_always_defrag)			echo "Please enable IP Defragmentation in your kernel!" ;;
				ip_dynaddr)				echo "Please enable Dynamic TCP/IP Address Hacking in your kernel!" ;;
				tcp_rfc1337)				echo "Please enable TCP RFC 1337 (TIME-WAIT) in your kernel!" ;;
				tcp_syncookies)				echo "Please enable TCP SYN Cookie protection in your kernel!" ;;
				*)					echo "$FILEPATH missing!"
			esac
		fi
	done
	unset FILENAME FILEPATH
	#
	# Examine each file within each interface directory.
	#
	for FILEPATH in /proc/sys/net/ipv4/conf/*/*
	do
		FILENAME=`Sed_Basename $FILEPATH`
		INTERFACE=`Sed_Dirname $FILEPATH`
		INTERFACE=`Sed_Basename $INTERFACE`
		VALUE=""
		#
		# Define what the correct value should be.
		#
		case $FILENAME in
			accept_redirects)	VALUE="0" ;;
			accept_source_route)	VALUE="0" ;;
			bootp_relay)		VALUE="0" ;;
			log_martians)		VALUE="1" ;;
			proxy_arp)		VALUE="0" ;;
			rp_filter)
				#
				# This drops traffic addressed for one network though it is 
				# being received on a different interface.
				#
				# A few things need to be in place in order to disable (ie: 0)
				# ip_filter on an interface. The /etc/ipsec.conf file must
				# exist, the ACCEPT_[INT}_IPSECVPN_HOSTS variable must be set, 
				# and the interface must be listed in the /etc/ipsec.conf 
				# file.
				#
				if [ -f /etc/ipsec.conf ]
				then
					[ "`Option_Value accept $INTERFACE ipsecvpn hosts`" \
						-a "`grep \"interfaces=.*[=\\"]?$INTERFACE\" \
						/etc/ipsec.conf 2>/dev/null`" ] && VALUE="0" || VALUE="1"
					
				else
					VALUE="1"
				fi
				;;
			*)	: ;;
		esac
		#
		# If we've defined a correct value, and the file isn't set this way,
		# then display a message and fix the file.
		#
		[ "$VALUE" ] && if [ "`Sed_Cat $FILEPATH`" -ne "$VALUE" ]
		then
			INTERFACE_LEN=${#INTERFACE}
			while [ ! $INTERFACE_LEN -eq 7 ]
			do
				echo -n " "
				INTERFACE_LEN="`expr $INTERFACE_LEN + 1`"
			done
			echo -n "$INTERFACE: "

			case $FILENAME in
				accept_redirects)	echo "Disabling Redirects" ;;
				accept_source_route)	echo "Disabling Source Routing" ;;
				bootp_relay)		echo "Disabling BOOTP Relay" ;;
				log_martians)		echo "Enabling Logging of Spoofed, Source-Routed, & Redirect Packets" ;;
				proxy_arp)		echo "Disabling Proxy ARP" ;;
				rp_filter)
					case $VALUE in
						0)	echo "Disabling Route Filtering" ;;
						1)	echo "Disabling IP Spoofing" ;;
					esac
					;;
				*)
					case $VALUE in
						0)	echo "Disabling \"${FILENAME}\" Setting" ;;
						1)	echo "Enabling \"${FILENAME}\" Setting" ;;
					esac
					;;
			esac
			[ "$TEST" ] \
				&& echo "	echo \"${VALUE}\" >$FILEPATH" >>/dev/stderr \
				|| echo "${VALUE}" >$FILEPATH
		fi
	done
	unset FILEPATH FILENAME INTERFACE VALUE
}

