
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-28  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "tr" by To_Upper/To_Lower functions.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Option_Value () {
	#
	# Returns the value of an option. Sample code:
	#
	#     if [ "`Option_Value ENABLE $INTOPT DHCP CLIENTS`" = "yes" ]
	#     then
	#         ...
	#     fi
	#
	# $1: Action (enable, accept, deny, etc.)
	# $2: Interface (eth0, etc.)
	# $3: Service (telnet, etc.)
	# $4: Type (servers, clients, hosts, etc.)
	#
	VAR="`echo ${1}_${2}_${3}_${4}|To_Upper_Fix`"
	eval echo \"\$$VAR\"
}

