
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-28  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "tr" by To_Upper/To_Lower functions.
# 2001-03-17  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Removed "wc" command.
# 2001-02-19  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Fixed quite a few typos. :-)
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Port_Forwarding_Rules () {

	for INTERFACE_TYPE in $*
	do
		LCASE_TYPE="`echo $INTERFACE_TYPE|To_Lower`"
		UCASE_TYPE="`echo $INTERFACE_TYPE|To_Upper`"
		eval INTERFACES=\"\$${UCASE_TYPE}_INTERFACES\"

		case $LCASE_TYPE in
			public|dmz)	MODULE_SUBDIR="public"	;;
			private|mz)	MODULE_SUBDIR="private"	;;
		esac

		for INTERFACE in $INTERFACES
		do
			Get_Interface_Vars "$INTERFACE"
			for MODULE in ${MODULE_DIR}/${MODULE_SUBDIR}/port-forwarding/*
			do
				if [ -f "$MODULE" ]
				then
					eval INTERFACES_MODE="\$${UCASE_TYPE}_INTERFACES_MODE"	# may be used in module code.
					MODULE_MODE="`sed -n -e 's/^#[mM]#  *\([ 0-9]*\)/\1/p' $MODULE`"
	
					if [ ! "$MODULE_MODE" -o \( "`echo $MODULE_MODE|grep \"$INTERFACES_MODE\"`" \) ]
					then
						. "$MODULE" "$MODULE"
					fi
					unset MODULE_MODE
				fi
			done

			Forward_Hostports tcp "" `Option_Value forward $INTERFACE tcp hostports`
			Forward_Hostports udp "" `Option_Value forward $INTERFACE udp hostports`
		done
	done
}

