
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
# This function defines a special in/output chains to block private
# networks addresses on public interfaces. All packets on public 
# interfaces will jump to these chains AFTER DHCP clients and BEFORE
# any service use the "any/0" wildcard.
#
#-----------------------------------------------------------------------
# CHANGES
#-----------------------------------------------------------------------
#
# 2001-03-23  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Removed forced logging from RETURN command.
# 2001-03-22  Vladimir Smelhaus <smelhaus@bpt.cz>
#             Rewritten from Jean-Sebastien Morisset's 
#             090-PRIVATE-NETWORKS
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Private_Networks_Chains () {

    if [ "$PUBLIC_INTERFACES" -o "$DMZ_INTERFACES" ]
    then
		echo "Creating prii/prio Chains and Adding Deny/Reject Rules"

        ipchains -N prii
        ipchains -N prio

        ipchains -A prii -j DENY   -s $CLASS_A_PRIVATE -l
        ipchains -A prii -j DENY   -d $CLASS_A_PRIVATE -l
        ipchains -A prio -j REJECT -s $CLASS_A_PRIVATE -l
        ipchains -A prio -j REJECT -d $CLASS_A_PRIVATE -l

        ipchains -A prii -j DENY   -s $CLASS_B_PRIVATE -l
        ipchains -A prii -j DENY   -d $CLASS_B_PRIVATE -l
        ipchains -A prio -j REJECT -s $CLASS_B_PRIVATE -l
        ipchains -A prio -j REJECT -d $CLASS_B_PRIVATE -l

        ipchains -A prii -j DENY   -s $CLASS_C_PRIVATE -l
        ipchains -A prii -j DENY   -d $CLASS_C_PRIVATE -l
        ipchains -A prio -j REJECT -s $CLASS_C_PRIVATE -l
        ipchains -A prio -j REJECT -d $CLASS_C_PRIVATE -l

        ipchains -A prii -j DENY   -s $CLASS_E_RESERVED_NET -l

		# If the end of a user-defined chain is reached, or a rule
		# with target RETURN is matched, then the next rule in the
		# previous (calling) chain is examined.  
		#
		# If the end of a builtin chain is reached, or a rule  
		# in a builtin chain with target RETURN is matched, 
		# the target specified by the chain policy determines
		# the fate of the packet.

        ####ipchains -A prii -j RETURN $LOG
        ####ipchains -A prio -j RETURN $LOG

    fi
}
