
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-19  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "cat" command with Sed_Cat function. Changed do-
#             while loop with sed command to set option variables.
# 2001-03-05  Vladimir Smelhaus <smelhaus@bpt.cz>
#             Added grep before sed command when reading config file to
#             make it a little faster.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Read_Config () {
	if [ ! -s "$CONF" ]
	then
		if [ ! -r "$CONF" ]
		then
			echo "The $CONF configuration file is missing. A new one will be"
			echo "created. Please edit this file and re-run the firewall script."
		else
			echo "The $CONF configuration file is being updated. Please"
			echo "edit this file and re-run the firewall script."
		fi
	
		# This is the first time we run this script (no config file yet).
		# Write a new configuration file (below) and exit immediately.
		#
		[ "$UPDATE_CONFIG" != "yes" ] && UPDATE_CONFIG="yes"
	
		# Setup initial variables for new configuration file.
		#
		Set_Default_Vars
	else
		echo "Reading $CONF Configuration..."

		# Get the configuration file version number.
		#
		CONF_VERSION="`sed -n -e 's/# Firewall v\(.*\) Config.*$/\1/p' $CONF`"

		# convert lower case variables to upper case and change dash & colon
		# characters into underscore. Variables are set in a way not to over-
		# ride existing values.
		#
		eval : `grep -v "^ *$\|^ *#" $CONF | \
			sed -n -e 's/^ *\([^ #]*\) *= *\"*\([^\\"#]*\).*$/\1=\2/;h;s/\(.*\)=.*/\1/;y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/;s/[:-]/_/g;G;s/\(.*\)\n.*=\(.*\)/\${\1=\"\2\"}/p;'`

		# If we haven't asked to update it, and the version number differs, 
		# then display a warning about the mismatch.
		#
		if [ ! "$UPDATE_CONFIG" -a "$CONF_VERSION" != "$VERSION" ]
		then
			Sed_Cat <<EOF

Version mismatch between script and configuration file! You must execute
`Sed_Basename $0` with the --update-config parameter to fix this problem. Since all 
variables and options are backwards compatible, the script will continue.
EOF
			echo ""
			echo -n "Pausing for $ERROR_PAUSE secs..."; sleep $ERROR_PAUSE; echo ""
			echo ""
		fi

		# Only execute if the configuration file isn't of the same version.
		#
		[ "$CONF_VERSION" != "$VERSION" ] && Convert_Options
	fi
}

