
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
# sed based functions to replace common unix binaries (cat, wc, uniq, 
# etc.).
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-26  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Added sed_sort function.
# 2001-03-19  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Function added to v5.1.1a4 development code.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Sed_Basename () {
	echo "$1" | sed -e 's/^[    ]*//;s/[     ]*$//;tc;:c;s/[     ][      ]*/\;/;ta;s/\/*$//;s/.*\///;b;:a;h;s/.*\n//;x;s/\n.*//;s/\/*$//;s/.*\///;tb;:b;G;s/^\(.*\)\(.*\)\n\2$/\1/;t;P;d;'
}

Sed_Cat () {
	sed -e '' $*
}

Sed_Dirname () {
	echo "$1" | sed -e '
# special case: / is given
/^\/$/c\
/

# strip trailing / if any
s/\/*$//

# strip trailing filename
s/[^/]*$//

# if get no chars after these, then we have current dir (things like
# bin/ src/ were given
/./!c\
.

# delete the trailing /
# ("/usr/bin/ls" --> "/usr/bin/", this makes "/usr/bin")
s/\/$//
'
}

Sed_Length () {
	echo "$*" | sed -e 's/./\
/g;s/.$//' | Sed_Wc
}

Sed_Uniq () {
	sed -e ':a;N;/\([^\n]\+\)\n\1/!{;P;D;};s//\1/;b a' $*
}

Sed_Wc () {
	sed -n -e '$=' $*
}

