
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-05-21  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replace "lo" by $LOOPBACK_INTERFACES
# 2001-04-21  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Changed Accept_Hostports function call to Hostports.
# 2001-04-18  Dougal Holmes <dholmes@bigpond.net.au>
#             Changed the Accept_Hostports INTERFACE param to INTOPT.
# 2001-03-23  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Removed forced logging from iana chain jump.
# 2001-03-22  Vladimir Smelhaus <smelhaus@bpt.cz>
#             Changed for use with new user input ianai chain
#             which is defined in iana_networks_chains.sh
# 2001-03-17  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Removed "wc" command.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Service_Rules () {

	INTERFACE_TYPE="$1"
	INTERFACE_MODE="$2"

	# Illegal/malformed addresses must be blocked BEFORE opening
	# services which use any/0 (like http, smtp, etc.).
	#
	# Private networks are denied in a MODULE. This is because
	# some ISPs use private addresses on their network for DHCP
	# services. Private networks are blocked after DHCP client
	# rules are implemented.

	if [ ! "$CLUSTER_NAME" -a "$VIRTUAL" = "no" ]
	then
		Illegal_Malformed_Address_Rules

		if [ "$INTERFACE_TYPE" = "public" ]
		then
			all_private_subnets="`{
				for private_interface in $LOOPBACK_INTERFACES $PRIVATE_INTERFACES $MZ_INTERFACES
				do
					Get_Interface_Vars "$private_interface" "PRIVATE"
					Device_Subnets PRIVATE
				done
				unset private_interface
			} | sort | Sed_Uniq`"

			for private_subnet in $all_private_subnets
			do
				echo "Reject $INTERFACE Stuffed Masquerading $private_subnet -> $ANY (logged)"
				ipchains -A $OUTCHAIN -j REJECT -s $private_subnet -d $ANY -l

				# Don't allow private interface IPs from/to public interfaces.
				# All traffic should be masqueraded in these cases. Private IPs
				# are OK for DMZ interfaces.
				#
				echo "Deny $INTERFACE IP Spoofing $ANY <- $private_subnet (logged)"
				ipchains -A $INCHAIN -j DENY -s $private_subnet -d $ANY -l

				echo "Reject $INTERFACE Stuffed Routing $ANY -> $private_subnet (logged)"
				ipchains -A $OUTCHAIN -j REJECT -s $ANY -d $private_subnet -l
			done
			unset private_subnet

			if [ "$IANA_RESERVED_NETWORKS" ]
			then
			    echo "Deny $INTERFACE <- IANA Reserved Networks (logged)" 
			    ipchains -A $INCHAIN -j ianai $LOG
			fi

		fi
	fi
	#-------------------------------------------------------------------
	# Service Modules
	#-------------------------------------------------------------------
	
	for MODULE in ${MODULE_DIR}/${INTERFACE_TYPE}/services/[0-9][0-9][0-9]-*
	do
		if [ -f "$MODULE" ]
		then
			MODE="$INTERFACE_MODE"	# may be used in module code
			MODULE_MODE="`sed -n -e 's/^#[mM]#  *\([ 0-9]*\)/\1/p' $MODULE`"
			if [ ! "$MODULE_MODE" -o \( "`echo $MODULE_MODE|grep \"$INTERFACE_MODE\"`" \) ]
			then
				. "$MODULE" "$MODULE"
			fi
			unset MODULE_MODE
		fi
	done

	#--------------------------------------------------------------------
	# Misc. UDP and TCP Ports
	#--------------------------------------------------------------------
	# The "HOSTPORTS" variables have a different structure -- we don't 
	# need a for-loop here for host names.
	#--------------------------------------------------------------------

	Hostports accept local tcp "" "`Option_Value accept $INTOPT tcp hostports`"
	Hostports accept local udp "" "`Option_Value accept $INTOPT udp hostports`"

	unset INTERFACE_TYPE INTERFACE_MODE
}

