
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-04-19  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Cleared the cluster_name variable before the for-loop.
#             Otherwise, clusters after the 1st were skipped.
# 2001-03-28  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "tr" by To_Upper/To_Lower functions.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Set_Cluster_Vars () {
	for int_type_arg in $*
	do
		int_type_arg=`echo $int_type_arg|To_Upper`
		eval interfaces_option_value=\"\$${int_type_arg}_INTERFACES\"

		for interface_name in $interfaces_option_value
		do
			device="`echo $interface_name|sed -n -e 's/^\([^\:]*\).*$/\1/p'`"
			[ "$device" != "$interface_name" ] && VIRTUAL="yes" || VIRTUAL="no"

			if [ "$VIRTUAL" = "no" ]
			then
				ucase_interface_name=`echo $interface_name|To_Upper_Fix`
				eval clusters=\"\$${int_type_arg}_${ucase_interface_name}_CLUSTERS\"
				clusters="`echo $clusters|sed -e 's/,/ *separator* /g'`"
				cluster_name=""
		
				for field in $clusters
				do
					if [ "$field" = "*separator*" ]
					then
						cluster_name=""
					elif [ ! "$cluster_name" ]
					then
						field="`echo $field|sed 's/[^a-zA-Z0-9]//g'`"
						cluster_name="`echo $field|To_Upper`"
						eval ${int_type_arg}_${ucase_interface_name}_CLUSTER_NAMES=\"\$${int_type_arg}_${ucase_interface_name}_CLUSTER_NAMES $field\"
					else
						eval ${int_type_arg}_${ucase_interface_name}_${cluster_name}_CLUSTER=\"\$${int_type_arg}_${ucase_interface_name}_${cluster_name}_CLUSTER $field\"
					fi
				done
			fi
		done
	done
	unset int_type_arg interfaces_option_value interface_name
	unset ucase_interface_name clusters field cluster_name
	unset device
}

