
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
# Try to determine the private and public interfaces.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-28  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "ifconfig" with "ip" command for LRP compat.
# 2001-03-04  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Used ifconfig instead of netstat to find interface names.
# 2001-02-12  Edwin ten Brink <edwin@privateer.student.utwente.nl>
#             Prepared function for port to LRP
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Set_Default_Vars () {
	
	ALL_INTERFACES="`All_Interfaces|grep -v 'lo'`"

	for INTERFACE in $ALL_INTERFACES
	do
		IPADDR="`Interface_Addr ${INTERFACE}`"
		case $IPADDR in
			10.*|172.16.*|192.168.*)
				[ ! "$PRIVATE_INTERFACES" ] \
					&& PRIVATE_INTERFACES="$INTERFACE" \
					|| PRIVATE_INTERFACES="$PRIVATE_INTERFACES $INTERFACE"
				;;
			*)
				[ ! "$PUBLIC_INTERFACES" ] \
					&& PUBLIC_INTERFACES="$INTERFACE" \
					|| PUBLIC_INTERFACES="$PUBLIC_INTERFACES $INTERFACE"
				;;
		esac
	done
}

