
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-04-22  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Removed warning for BITLEN not set.
# 2001-03-30  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Added check for ip address taken from dhcpcd.info file and
#             the real interface. An error message is printed if a 
#             conflict is found. Replaced "tr" by To_Upper/To_Lower 
#             functions. Replaced "ifconfig" by "ip" command. Added
#             BITLEN variable and Bitlen_To_Netmask function to
#             calculate the NETMASK variable.
# 2001-03-19  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "cat" command by Sed_Cat function. 
# 2001-03-04  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Added for-loop to check if all essential variables have
#             been set.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Set_Interface_Vars () {
	#
	# syntax: Set_Interface_Vars LOOPBACK PUBLIC PRIVATE DMZ MZ
	#
	for ARG_INTERFACE_TYPE in $*
	do
		ARG_INTERFACE_TYPE=`echo $ARG_INTERFACE_TYPE|To_Upper`
		eval ARG_INTERFACES=\"\$${ARG_INTERFACE_TYPE}_INTERFACES\"

		for ARG_INTERFACE in $ARG_INTERFACES
		do
			UCASE_INTERFACE="`echo $ARG_INTERFACE|To_Upper_Fix`"

			IPADDR=""
			BITLEN=""
			NETMASK=""
			NETWORK=""
			BROADCAST=""

			if [ -f /etc/dhcpc/dhcpcd-${ARG_INTERFACE}.info ]
			then
				echo "Reading /etc/dhcpc/dhcpcd-${ARG_INTERFACE}.info..."
				eval `Sed_Cat /etc/dhcpc/dhcpcd-${ARG_INTERFACE}.info`

				if [ "$IPADDR" -a "$IPADDR" != "`Interface_Addr $ARG_INTERFACE`" ]
				then
					echo "WARNING: Possible DHCPCD Configuration Error!"
					echo "IP Address from dhcpcd-${ARG_INTERFACE}.info is $IPADDR."
					echo "Possible Conflict with Interface Settings:"

					if [ "`which ip 2>/dev/null`" ]
					then
						ip addr show dev `echo $ARG_INTERFACE|sed -e 's/^\([^\:]*\).*\$/\1/'`
					elif [ "`which ifconfig 2>/dev/null`" ]
					then
						ifconfig $ARG_INTERFACE
					fi
				fi
			fi

			# Sample content for /etc/dhcpc/dhcpcd-eth1.info:
			#
			#	BROADCAST=255.255.255.255
			#	DHCPCHADDR=00:50:BA:B0:64:21
			#	DHCPGIADDR=0.0.0.0
			#	DHCPSHADDR=00:90:BF:5A:38:52
			#	DHCPSIADDR=0.0.0.0
			#	DHCPSID=24.200.243.150
			#	DHCPSNAME=
			#	DNS=205.151.222.250,205.151.222.251
			#	DOMAIN=videotron.ca
			#	GATEWAY=24.200.96.1
			#	INTERFACE=eth1
			#	IPADDR=24.200.96.155
			#	LEASETIME=60538
			#	NETMASK=255.255.255.0
			#	NETWORK=24.200.96.0
			#	REBINDTIME=52970
			#	RENEWALTIME=30269
	
			[ ! "$IPADDR" ] && IPADDR="`Interface_Addr $ARG_INTERFACE`"

			[ ! "$BITLEN" ] && BITLEN="`Interface_Bitlen $ARG_INTERFACE`"
			
			[ ! "$NETMASK" ] && NETMASK="`Interface_Netmask $ARG_INTERFACE`"	# succeeds if ifconfig found
			[ ! "$NETMASK" ] && NETMASK="`Bitlen_To_Netmask $BITLEN`"			# otherwise use ip command

			[ ! "$NETWORK" ] && NETWORK="`Subnet_Calc -n $IPADDR $NETMASK`"

			[ ! "$BROADCAST" ] && BROADCAST="`Interface_Broadcast $ARG_INTERFACE`"	# succeeds if ifconfig found
			[ ! "$BROADCAST" ] && BROADCAST="`Subnet_Calc -b $IPADDR $NETMASK`"

			# Verify that we have all the essential variables set.
			for variable_name in IPADDR NETMASK NETWORK BROADCAST
			do
				eval variable_value=\"\$$variable_name\"
				[ ! "$variable_value" ] && echo "WARNING: Unable to determine $variable_name for ${ARG_INTERFACE}."
			done
			unset variable_name variable_value
			
			eval ${UCASE_INTERFACE}_IPADDR=\"$IPADDR\"
			eval ${UCASE_INTERFACE}_BITLEN=\"$BITLEN\"
			eval ${UCASE_INTERFACE}_NETMASK=\"$NETMASK\"
			eval ${UCASE_INTERFACE}_NETWORK=\"$NETWORK\"
			eval ${UCASE_INTERFACE}_BROADCAST=\"$BROADCAST\"
			eval ${UCASE_INTERFACE}_INCHAIN=\"`echo ${ARG_INTERFACE}|sed -n -e 's/^\([^:]*\).*$/\1/p'`i\"
			eval ${UCASE_INTERFACE}_OUTCHAIN=\"`echo ${ARG_INTERFACE}|sed -n -e 's/^\([^:]*\).*$/\1/p'`o\"
		done
	done
	unset ARG_INTERFACE_TYPE ARG_INTERFACES ARG_INTERFACE UCASE_INTERFACE
}

