
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-05-17  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Changed checking of mode to first letter of the mode
#             name (upper or lower case). Also added a warning
#             when defaulting to paranoid mode.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Set_Mode_Num () {
	# Set the PUBLIC_INTERFACES_MODE etc. variables.
	# Numeric values are easier to test against.
	#
	for interface_type in PUBLIC PRIVATE DMZ MZ
	do
		for group_type in INTERFACES CLUSTERS
		do
			eval value=\"\$${interface_type}_${group_type}_SECURITY\"
			[ "$value" ] && case $value in
				o*|O*)
					if [ "$interface_type" != "PRIVATE" ]
					then
						echo ""
						echo "WARNING: open mode is only supported on private interfaces!"
						echo "Please change the value of ${interface_type}_${group_type}_SECURITY."
						echo ""
						exit 1
					fi
					eval ${interface_type}_${group_type}_MODE=\"0\"
					;;
				r*|R*)	eval ${interface_type}_${group_type}_MODE=\"1\" ;;
				s*|S*)	eval ${interface_type}_${group_type}_MODE=\"2\" ;;
				p*|P*)	eval ${interface_type}_${group_type}_MODE=\"3\" ;;
				*)		echo "WARNING: Setting ${interface_type}_${group_type}_MODE to paranoid."
						eval ${interface_type}_${group_type}_MODE=\"3\" ;;
			esac
		done
	done
	unset interface_type group_type value
}

