
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-05  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Changed value of "off" to "no" instead of "yes".
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Set_Yn_Variable () {
	if [ "$1" ]
	then
		eval VALUE="\$${1}"
		case "$VALUE" in
			1)		NEW_VALUE="yes";;
			0)		NEW_VALUE="no";;
			Y*|y*)	NEW_VALUE="yes";;
			N*|n*)	NEW_VALUE="no";;
			T*|t*)	NEW_VALUE="yes";;
			F*|f*)	NEW_VALUE="no";;
			On|ON|on)	NEW_VALUE="yes";;
			Of*|OF*|of*)	NEW_VALUE="no";;
			*)	NEW_VALUE="";;
		esac
		eval ${1}="${NEW_VALUE}"
		unset NEW_VALUE
	fi
}

