
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-05-21  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replace "lo" by $LOOPBACK_INTERFACES
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Show_Config () {

	echo ""
	echo "Configuration Options:"
	echo ""
	sed -n -e 's/^ *\([^ #]*\) *= *\"*\([^\\"#][^\\"#][^\\"#]*\).*$/\1 = \2/p' $CONF

	echo ""
	echo "Interface Related Variables:"
	echo ""
	{
		for interface in $LOOPBACK_INTERFACES $PUBLIC_INTERFACES $PRIVATE_INTERFACES $DMZ_INTERFACES $MZ_INTERFACES
		do
			ucase_interface="`echo $interface|Sed_To_Upper_Fix`"
			set | grep "^[A-Z0-9_]*${ucase_interface}_[A-Z0-9_]*=..*"
		done
		unset ucase_interface
	} | sort | Sed_Uniq
}

