
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
# Return the network and/or broadcast addresses.
# Syntax: Subnet_Calc -[n|b] {IP} {Netmask}
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-23  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced ipcalc and perl commands with a few sed scripts.
#             Many thanks to Laura Fairhead <laura_fairhead@talk21.com>
#             for this wonderful code.
# 2001-03-17  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Moved testing of "which" binary to main rcf script.
# 2001-03-04  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Added check and use of "which" binary instead of built-in
#             shell version.
# 2001-03-03  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Added check for executable bit on output from "which".
# 2001-02-11  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Added check for ipcalc executable which comes standard on
#             Red Hat installations.
# 2001-02-10  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Initial function file written for rcf version 5.1.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Subnet_Calc () {

	case $1 in
		-b) line_number="1" ;;
		-n) line_number="2" ;;
	esac

	[ "$line_number" -a "$2" -a "$3" ] && { 
		echo "$2"
		echo "$3"
	} | sed -n -e '
			N
			s/\([^.]*\).\([^.]*\).\([^.]*\).\([^.]*\)\(\n\)\([^.]*\).\([^.]*\).\([^.]*\).\([^.]*\)/\6\5\1\5\7\5\2\5\8\5\3\5\9\5\4/p
	' | sed -n -e '
			N
			s/\n/;/
			s/$/;:-TbRTbDRRDRARNANBtPRBtP/

		#parse next command
		:ret0
			s/:./:/
		:loop
			/:T/b op_d2s
			/:t/b op_s2d
			/:B/b op_b2s
			/:b/b op_s2b
			/:P/b op_prt
			/:N/b op_not
			/:A/b op_and
			/:D/b op_dup
			/:R/b op_rot
			/:\$/b op_dump
		
			#done -- exit
			b
		
		#return to parse loop re-appending buffer
		:ret1
			G
			s/\n[^;]*//
			b ret0
		
		#'$' dump
		:op_dump
			p
			b ret0
			
		#'R' rotate
		:op_rot
			s/\([^;]*;\)\([^:]*\)/\2\1/
			b ret0
			
		#'D' dup
		:op_dup
			s/[^;]*/&;&/
			b ret0
			
		#'P' print top of stack
		:op_prt
			h
			s/;.*//p
			b ret1
			
		#'T' decimal to scalar
		:op_d2s
			h
			s/;.*//
		:d1
			s/!/!!!!!!!!!!/g
			s/$/;9876543210!!!!!!!!!/
			s/\([0-9]\)\(.*\);.*\1.\{9\}\(.*\)/\3\2/
			/[0-9]/b d1
			b ret1
			
		#'B' binary to scalar
		:op_b2s
			h
			s/;.*//
		:d7
			s/!/!!/g
			s/^\(!*\)1/\1-/
			/-/!s/0//
			s/-/!/
			/[01]/b d7
			b ret1
			
		# 'b' scalar to binary
		:op_s2b
			h
			s/;.*//
			s/$/00000000/
			s/!\{128\}\(!*\)./\11/
			s/!\{64\}\(!*.\)./\11/
			s/!\{32\}\(!*..\)./\11/
			s/!\{16\}\(!*...\)./\11/
			s/!\{8\}\(!*....\)./\11/
			s/!\{4\}\(!*.....\)./\11/
			s/!\{2\}\(!*......\)./\11/
			s/!\(.......\)./\11/
			b ret1
			
		# 't' scalar to decimal  (tested exhaustively for 0-255)
		:op_s2d
			h
			s/;.*//
		:d5
			s/!!!!!!!!!!/-/g
			s/$/;!!!!!!!!!0123456789/
			s/\(-*\)\(!*\)\(.*\);\2.\{9\}\(.\).*/\1\4\3/
			y/-/!/
			/!/b d5
			b ret1
			
		#'N' binary NOT
		:op_not
			h
			s/;.*//
			y/01/10/
			b ret1
			
		#'A' binary AND
		:op_and
			h
			s/\([^;]*;[^;]*\).*/\1/
		:d6
			s/1\(........0\)/0\1/
			/1........0/b d6
			s/;.*//
			x
			s/[^;]*;//
			x
			b ret1
	'| sed -n -e '
			x
			n
		:l0
			x
			N
			s/\n/./
			7,8p
			8!b l0
	' | sed -n -e "${line_number},${line_number}p"

	unset line_number

}

