
#-----------------------------------------------------------------------
# README
#-----------------------------------------------------------------------
#
# A bourne shell function used by rcf; a very secure, fast, and complete
# firewall for linux <http://jsmoriss.mvlan.net/linux/rcf.html>.
#
#-----------------------------------------------------------------------
# CHANGES 
#-----------------------------------------------------------------------
#
# 2001-03-28  Jean-Sebastien Morisset <jsmoriss@mvlan.net>
#             Replaced "tr" by To_Upper/To_Lower functions.
#
#-----------------------------------------------------------------------
# FUNCTION
#-----------------------------------------------------------------------

Verify_All_Yn_Variables () {
	
	# Save interface names suitable for variable insertion. ie: eth0:1 -> ETH0_1
	#
	UCASE_PRIVATE_INTERFACES="`echo $PRIVATE_INTERFACES|To_Upper_Fix`"
	UCASE_PUBLIC_INTERFACES="`echo $PUBLIC_INTERFACES|To_Upper_Fix`"

	for VAR in DEBUG
	do
		Set_Yn_Variable $VAR	# sets variable to "no" on null value
	done

	for INTERFACE in $UCASE_PRIVATE_INTERFACES
	do
		# Private interface variables which need y/n checking.
		for VAR in ENABLE_${INTERFACE}_DHCP_CLIENTS
		do
			Set_Yn_Variable $VAR	# sets variable to "no" on null value
		done
	done
}

