
/******************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**  File:    mod_dns.c
**  Date:    March 18, 2004
**
**  Author:  Brian Wotring
**  Purpose: monitor used nameservers.
**
******************************************************************************/

#include "libosiris.h"
#include "libfileapi.h"
#include "rootpriv.h"
#include "common.h"
#include "version.h"

#include "scanner.h"
#include "logging.h"

static const char *MODULE_NAME = "mod_dns";

#ifdef SYSTEM_DARWIN
static const char *DNS_FILE    = "/var/run/resolv.conf";
#else
static const char *DNS_FILE    = "/etc/resolv.conf";
#endif


#ifdef WIN32

#else
void process_resolv_file( SCANNER *scanner )
{
    char temp_line[MAX_TEXT_RECORD_DATA_LENGTH];
    char value[MAX_TEXT_RECORD_NAME_LENGTH];

    FILE *file;
    SCAN_RECORD_TEXT_1 record;

    /* open the /etc/resolv.conf file. */

    file = osi_fopen( DNS_FILE, "r", 0 );

    if( file == NULL )
    {
        log_error( "unable to open local user file (%s).", DNS_FILE );
        return;
    }
   
    /* go through each line, looking or DNS keywords. */ 

    for(;;)
    {
        char *line;

        line = fgets( temp_line, sizeof( temp_line ), file );

        if( line == NULL)
        {
            break;
        }

        /* look for lines beginning with "nameserver" or "search". */

        line = get_token( line, value, sizeof( value ) );

        if( ( strcmp( value, "search" ) ) && ( strcmp( value, "nameserver" ) ) )
        {
            continue;
        }
    
        initialize_scan_record( (SCAN_RECORD *)&record,
                                SCAN_RECORD_TYPE_TEXT_1 );

        osi_strlcpy( record.module_name, MODULE_NAME,
                     sizeof( record.module_name ) );

        /* store the keyword as the data value. */

        osi_strlcpy( record.data, value, sizeof( record.data ) );

        /* use the nameserver address as a key. */

        get_token( line, value, sizeof( value ) );        
        osi_strlcpy( record.name, value , sizeof( record.name ) );

        send_scan_data( scanner, (SCAN_RECORD *)&record );
    }    

    fclose( file );
}
#endif

void mod_dns( SCANNER *scanner )
{
#ifdef WIN32
#else
    process_resolv_file( scanner );
#endif
}


