/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <stdio.h>
#include <assert.h>
#include <pwd.h>
#include <sys/stat.h>
#include <syslog.h>
#include "common.h"

int
acua_delRec(int argc, char **argv)
{
  int                      i,
                           n;
  uid_t                    uid;
  UserRec                  ur;
  char                    *tUserPath;
  FILE                    *tUserFile;

  readConfig();
  if (argc != 2)
    errQuit("usage: delRec <login>");
  uid = UIDfromLogin(argv[1]);
  if (uid == (uid_t) - 1)
    errQuit("user does not exist: %s", argv[1]);
  userFileOpen();
  if (userFileSearch(&ur, uid))
    errQuit("user not found: %s", argv[1]);

  // create a tempory file
  tUserPath = (char *) malloc(strlen(userFilePath)+8);
  sprintf(tUserPath, "%s%s", userFilePath, ".XXXXXX");
  if (!mktemp(tUserPath)) {
    // couldn't make the tempory file.
    free(tUserPath);
    syslog(LOG_ERR, "Could not create tempory file in [%s].", LIB);
    return(1);
  }

  chmod(tUserPath, 0644);
  tUserFile = fopen(tUserPath, "wb");
  assert(tUserFile != NULL);
  fwrite(ACUA_USERS_MAGIC, 1, ACUA_USERS_MAGIC_LEN, tUserFile);
  n = ftell(userFile) / sizeof(UserRec) - 1;
  userFileRewind();
  for (i = 0;; i++) {
    if (userFileRead(&ur))
      break;
    if (i == n)
      continue;
    fwrite(&ur, sizeof(UserRec), 1, tUserFile);
  }
  userFileClose();
  if (fclose(tUserFile)) {
    // error writing to our tempory file.
    perror("fclose");
    unlink(tUserPath);
    free(tUserPath);
    syslog(LOG_ERR, "file i/o error occoured, disk/permission problem?");
    printf("file i/o error occoured, disk/permission problem?\n");
    return(1);
  }
  if (rename(tUserPath, userFilePath)) {
    // error moving the new database over the old one.
    unlink(tUserPath);
    free(tUserPath);
    syslog(LOG_ERR, "could not replace userbase, disk/permission problem?");
    printf("could not replace userbase, disk/permission problem?");
    return(1);
  }
  unlink(tUserPath);
  free(tUserPath);
  chmod(userFilePath, 0644);
  printf("user deleted: %s\n", argv[1]);
  return(0);
}
