/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include "common.h"

int
acua_dumpStats(int argc, char **argv)
{
  int       i;
  char      name[256], path[256];
  UsageRec  usage;
  FILE     *f;

  if (argc == 1)
    strcpy(name, "overall");
  else
    strcpy(name, argv[1]);
  if (name[0] == '/') {
    f = fopen(name, "rb");
  } else {
    sprintf(path, LIB"/record/%s", name);
    f = fopen(path, "rb");
    if (!f) {
      sprintf(path, LIB"/record/archive/%s", name);
      f = fopen(path, "rb");
    }
  }
  if (!f) errQuit("can't find statistics file: %s", name);

  fread(&usage, sizeof(UsageRec), 1, f);
  fclose(f);

  printf("%lu\n", usage.startTime);
  for (i = 0; i < 24 * 60; i++) {
    if (i) printf(" ");
    printf("%u", usage.nMinutes[i]);
  }
  printf("\n");
  for (i = 0; i < 24 * 60; i++) {
    if (i) printf(" ");
    printf("%u", usage.linesBusy[i]);
  }
  printf("\n");
  for (i = 0; i < 24 * 60; i++) {
    if (i) printf(" ");
    printf("%u", usage.sessionLength[i]);
  }
  return 0;
}
