/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <assert.h>
#include <signal.h>
#include "common.h"

static int                      nLoginRecs;
static LoginRec                 loginRec[MAX_USERS];
static int                      nProcs;
static ProcRec                  procRec[MAX_PROCS];
static HashTable                loginRecTable;
static HashTable                procRecTable;
static HashTable                PPPuserTable;

int
acua_kickUser(int argc, char **argv)
{
  int                      i,
                           nKill = 0;
  pid_t                    killPID[MAX_PROCS];
  uid_t                    uid;
  PPPuserRec               *PPPuser;

  readConfig();
  if (argc < 2)
    errQuit("usage: kick <login>");
  uid = UIDfromLogin(argv[1]);
  if (uid == (uid_t)-1)
    errQuit("user does not exist: %s", argv[1]);
  if (!uid)
    errQuit("can't kick root!");
  userList(&nLoginRecs, loginRec);
  procList(&nProcs, procRec);
  for (i = 0; i < nProcs; i++)
    if ((procRec[i].euid != 0) &&
        ((procRec[i].uid == uid) || (procRec[i].euid == uid)))
    {
      killPID[nKill++] = procRec[i].pid;
    }

  hashTableInit(&loginRecTable, MAX_USERS, TTYhash, TTYcomp,
                (word)&loginRec[0].tty - (word)&loginRec[0], FALSE);
  for (i = 0; i < nLoginRecs; i++)
    hashTableAdd(&loginRecTable, &loginRec[i]);
  
  hashTableInit(&procRecTable, MAX_PROCS, PIDhash, PIDcomp, 0, FALSE);
  for (i = 0; i < nProcs; i++)
    hashTableAdd(&procRecTable, &procRec[i]);
  
  PPPfindUnits(&PPPuserTable, &loginRecTable, &procRecTable);
  
  PPPuser = (PPPuserRec*)hashTableSearch(&PPPuserTable, &uid);
  if (PPPuser && PPPuser->root)
    killPID[nKill++] = PPPuser->pid;

  hashTableDeinit(&loginRecTable);
  hashTableDeinit(&procRecTable);
  hashTableDeinit(&PPPuserTable);

  if (!nKill) return 0;

  /* buh-bye */
  for (i = 0; i < nKill; i++)
    kill(killPID[i], SIGTERM);
  sleep(5);
  /* which part didn't you understand? the buh? or the bye? */
  for (i = 0; i < nKill; i++)
    kill(killPID[i], SIGKILL);  /* BUH-BYE */
  printf("user kicked: %s\n", argv[1]);

  return 0;
}
