/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include "common.h"

int
main(int argc, char **argv)
{
  int                      i;
  uid_t                    uid = getuid();
  int                      nLoginRecs;
  int                      sessionLength;
  LoginRec                 loginRec[MAX_USERS];
  char                     login[MAX_LOGINCHARS + 1];
  dev_t                    tty;
  Boolean                  loginFound;

  Boolean kick = TRUE;
  if ((argc == 2) && !strcmp(argv[1], "-k"))
  {
      if (getuid() == 0)
      {
          kick = FALSE;
      }
      else
      {
          printf("Only root can specify '-k'\n");
      }
  }

  readConfig();

  // figure out who to logout
  tty = devNumFromName(ttyname(STDIN_FILENO) + 5);
  userList(&nLoginRecs, loginRec);
  if (!uid) {
    if (argc == 1) {
      tty = devNumFromName(ttyname(STDIN_FILENO) + 5);
      for (i = 0; i < nLoginRecs; i++)
        if (loginRec[i].tty == tty) {
          uid = loginRec[i].uid;
          break;
        }
      if (i == nLoginRecs)
        return 1;
    } else {
      uid = UIDfromLogin(argv[1]);
      if (uid == (uid_t)-1)
        return 1;
      loginFound = FALSE;
      for (i = 0; i < nLoginRecs; i++)
        if ((lineNo(loginRec[i].tty) >= 0) && (loginRec[i].uid == uid)) {
          loginFound = TRUE;
          tty = loginRec[i].tty;
        }
      if (loginFound == FALSE)
        return 1;
    }
  }
  loginFromUID(login, uid);

  // mark them as logged out
  UserRec ur;
  userFileOpen();
  if (userFileSearch(&ur, uid))
    goto fail;
  char   hostname[256];
  word   myHostAddr;
  gethostname(hostname, 256);
  myHostAddr = hostAddr(hostname);
  int    hostIdx;
  hostIdx = findHost(&ur, myHostAddr);
  if ((hostIdx < 0) || ((time(NULL) - ur.lastLogin[hostIdx]) <= 60))
    goto fail;
  time_t t;
  time(&t);
  sessionLength = (t - ur.lastLogin[hostIdx]) / 60;
  if (sessionLength < optMinDeduct)
  {
    ur.tLeft -= (optMinDeduct - sessionLength);
    ur.sLeft = ur.sLimit - optMinDeduct;
  }
  removeHost(&ur, myHostAddr);
  userFileEdit(&ur);
  userFileClose();

  // exit right away if we're not kicking the user off
  if (!kick)
  {
      return 0;
  }

  // become a daemon so the user can logout normally
  daemonInit();

  // allow 5 seconds for them to leave
  sleep(5);

  // now ensure they are logged out
  char *_argv[2];
  _argv[0] = "kickUser";
  _argv[1] = login;
  acua_kickUser(2, _argv);

  return 0;
fail:
  userFileClose();
  return 0;
}
