/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include "common.h"

int
acua_pp(int argc, char **argv)
{
  uid_t                    uid;
  UserRec                  ur;
  char                     inPath[256];

  readConfig();
  if (argc != 4)
    errQuit("usage: pp <login> <infile> <outfile>");
  uid = UIDfromLogin(argv[1]);
  if (uid == (uid_t)-1)
    errQuit("user does not exist: %s", argv[1]);
  userFileOpen();
  if (userFileSearch(&ur, uid))
    errQuit("user not found: %s", argv[1]);
  if (argv[2][0] == '/') strcpy(inPath, argv[2]);
  else sprintf(inPath, LIB"/%s", argv[2]);
  preprocessFile(&ur, inPath, argv[3]);
  userFileClose();
  return 0;
}
