/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <string.h>
#include "common.h"

int
main(int argc, char **argv) {
  char     cmd[64];
  int      (*fn)(int,char**) = NULL;
  char    *script = NULL;

  if (argc < 2) errQuit("usage: acua <command> {arg}");

  strcpy(cmd, argv[1]);

  if (!strncasecmp(cmd, "addRec", 4)) {
    fn = acua_addRec;
  } else if (!strncasecmp(cmd, "addUser", 1)) {
    script = SBIN"/acua_adduser";
  } else if (!strncasecmp(cmd, "ban", 2)) {
    fn = acua_ban;
  } else if (!strncasecmp(cmd, "bytes", 1)) {
    script = BIN"/acua_bytes";
  } else if (!strncasecmp(cmd, "daysLeft", 2)) {
    fn = acua_daysLeft;
  } else if (!strncasecmp(cmd, "delRec", 4)) {
    fn = acua_delRec;
  } else if (!strncasecmp(cmd, "delUser", 2)) {
    script = SBIN"/acua_deluser";
  } else if (!strncasecmp(cmd, "dumpStats", 5)) {
    fn = acua_dumpStats;
  } else if (!strncasecmp(cmd, "dump", 1)) {
    fn = acua_dump;
  } else if (!strncasecmp(cmd, "expire", 1)) {
    fn = acua_expire;
  } else if (!strncasecmp(cmd, "forEach", 1)) {
    fn = acua_forEach;
  } else if (!strncasecmp(cmd, "kick", 1)) {
    fn = acua_kickUser;
  } else if (!strncasecmp(cmd, "lock", 1)) {
    fn = acua_lock;
  } else if (!strncasecmp(cmd, "modRec", 1)) {
    fn = acua_modRec;
  } else if (!strncasecmp(cmd, "pp", 2)) {
    fn = acua_pp;
  } else if (!strncasecmp(cmd, "purge", 1)) {
    fn = acua_purge;
  } else if (!strncasecmp(cmd, "renew", 5)) {
    fn = acua_renew;
  } else if (!strncasecmp(cmd, "stats", 2)) {
    script = BIN"/acua_stats";
  } else if (!strncasecmp(cmd, "subscribe", 2)) {
    fn = acua_subscribe;
  } else if (!strncasecmp(cmd, "sync", 1)) {
    fn = acua_sync;
  } else if (!strncasecmp(cmd, "timeLeft", 2)) {
    fn = acua_timeLeft;
  } else if (!strncasecmp(cmd, "touch", 1)) {
    fn = acua_touch;
  } else if (!strncasecmp(cmd, "unBan", 3)) {
    fn = acua_unBan;
  } else if (!strncasecmp(cmd, "unLock", 3)) {
    fn = acua_unLock;
  } else if (!strncasecmp(cmd, "unSubscribe", 1)) {
    fn = acua_unSubscribe;
  } else if (!strncasecmp(cmd, "version", 2)) {
      printf("ACUA Version: %s\n", ACUA_VERSION);
      printf("%s\n", ACUA_VERSION_EXTRA);
    return(0);
  } else if (!strncasecmp(cmd, "viewRec", 1)) {
    script = BIN"/acua_viewRec";
  } else {
    errQuit("unknown command: %s", cmd);
  }
  if (fn != NULL) {
    return fn(argc - 1, argv + 1);
  } else return runCommandV(script, argv + 2);
}
